/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.food;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.config.config.ItemConfig;
import crazypants.enderio.base.material.food.EnderFood;
import crazypants.enderio.base.material.food.SpecialFont;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.teleport.RandomTeleportUtil;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderFood
extends ItemFood
implements IResourceTooltipProvider,
IHaveRenderers {
    @SideOnly(value=Side.CLIENT)
    private SpecialFont fr;

    public static ItemEnderFood create(@Nonnull IModObject modObject) {
        return new ItemEnderFood(modObject);
    }

    public ItemEnderFood(@Nonnull IModObject modObject) {
        super(0, false);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77625_d(1);
        this.func_77627_a(true);
        modObject.apply(this);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (EnderFood f : EnderFood.VALUES) {
                list.add((Object)f.getStack());
            }
        }
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack itemStack) {
        return this.func_77658_a() + "." + EnderFood.get(itemStack).getUnlocalisedName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(final @Nonnull IModObject modObject) {
        NNList.of(EnderFood.class).apply((NNList.Callback)new NNList.Callback<EnderFood>(){

            public void apply(@Nonnull EnderFood alloy) {
                ModelLoader.setCustomModelResourceLocation((Item)ItemEnderFood.this, (int)alloy.ordinal(), (ModelResourceLocation)new ModelResourceLocation(modObject.getRegistryName(), "variant=" + alloy.getUnlocalisedName()));
            }
        });
    }

    public int func_150905_g(@Nonnull ItemStack stack) {
        return EnderFood.get(stack).getHunger();
    }

    public float func_150906_h(@Nonnull ItemStack stack) {
        return EnderFood.get(stack).getSaturation();
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.func_77667_c(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(@Nonnull ItemStack stack) {
        if (this.fr == null) {
            this.fr = new SpecialFont(Minecraft.func_71410_x().field_71466_p);
        }
        return this.fr;
    }

    protected void func_77849_c(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityPlayer player) {
        super.func_77849_c(stack, worldIn, player);
        if (!worldIn.field_72995_K && EnderFood.get(stack).doesTeleport() && worldIn.field_73012_v.nextFloat() < ((Float)ItemConfig.enderiosTeleportChance.get()).floatValue()) {
            RandomTeleportUtil.teleportEntity(worldIn, (Entity)player, true, false, ((Float)ItemConfig.enderiosTeleportRange.get()).floatValue());
        }
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return Prep.isValid(EnderFood.get(stack).getContainerItem());
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        return EnderFood.get(stack).getContainerItem();
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityLivingBase entityLiving) {
        ItemStack remaining = super.func_77654_b(stack, worldIn, entityLiving);
        ItemStack containerItem = EnderFood.get(stack).getContainerItem();
        if (Prep.isInvalid(containerItem)) {
            return remaining;
        }
        if (Prep.isInvalid(remaining)) {
            return containerItem;
        }
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).func_191521_c(containerItem);
        } else {
            entityLiving.func_70099_a(containerItem, 0.0f);
        }
        return remaining;
    }
}

