/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm;

import com.google.common.base.Strings;
import com.google.common.collect.ObjectArrays;
import com.google.common.io.Resources;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import logisticspipes.LPConstants;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.asm.transformers.AccessTransformer;
import net.minecraftforge.fml.common.asm.transformers.ModAccessTransformer;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.fml.relauncher.FileListHelper;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class DevEnvHelper {
    private static final Attributes.Name COREMODCONTAINSFMLMOD = new Attributes.Name("FMLCorePluginContainsFMLMod");
    private static Mapping m;
    private static IClassTransformer transformer;

    public static boolean isDevelopmentEnvironment() {
        if (!LPConstants.DEBUG) {
            return false;
        }
        boolean eclipseCheck = new File(".classpath").exists();
        boolean ideaCheck = System.getProperty("java.class.path").contains("idea_rt.jar");
        return eclipseCheck || ideaCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void detectCoreModInDevEnv() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException, IOException {
        void var15_18;
        if (!DevEnvHelper.isDevelopmentEnvironment()) {
            return;
        }
        Method handleCascadingTweak = CoreModManager.class.getDeclaredMethod("handleCascadingTweak", File.class, JarFile.class, String.class, LaunchClassLoader.class, Integer.class);
        handleCascadingTweak.setAccessible(true);
        Method loadCoreMod = CoreModManager.class.getDeclaredMethod("loadCoreMod", LaunchClassLoader.class, String.class, File.class);
        loadCoreMod.setAccessible(true);
        Method setupCoreModDir = CoreModManager.class.getDeclaredMethod("setupCoreModDir", File.class);
        setupCoreModDir.setAccessible(true);
        Field loadedCoremods = CoreModManager.class.getDeclaredField("loadedCoremods");
        loadedCoremods.setAccessible(true);
        Field reparsedCoremods = CoreModManager.class.getDeclaredField("reparsedCoremods");
        reparsedCoremods.setAccessible(true);
        Field mcDir = CoreModManager.class.getDeclaredField("mcDir");
        mcDir.setAccessible(true);
        Field transformers = LaunchClassLoader.class.getDeclaredField("transformers");
        transformers.setAccessible(true);
        LaunchClassLoader classLoader = Launch.classLoader;
        FMLRelaunchLog.fine((String)"Discovering coremods", (Object[])new Object[0]);
        File coreMods = (File)setupCoreModDir.invoke(null, mcDir.get(null));
        FilenameFilter ff = (dir, name) -> name.endsWith(".jar");
        Object[] FMLcoreModListArray = coreMods.listFiles(ff);
        File versionedModDir = new File(coreMods, "1.7.10");
        if (versionedModDir.isDirectory()) {
            Object[] versionedCoreMods = versionedModDir.listFiles(ff);
            FMLcoreModListArray = (File[])ObjectArrays.concat((Object[])FMLcoreModListArray, (Object[])versionedCoreMods, File.class);
        }
        ArrayList<String> FMLcoreModList = new ArrayList<String>();
        Object[] objectArray = FMLcoreModListArray;
        int n = objectArray.length;
        boolean bl = false;
        while (var15_18 < n) {
            Object f = objectArray[var15_18];
            FMLcoreModList.add(((File)f).getName());
            ++var15_18;
        }
        List<Object> coreModList = new ArrayList();
        for (URL path : classLoader.getURLs()) {
            File file = new File(URLDecoder.decode(path.getFile()));
            if (FMLcoreModList.contains(file.getName()) || !file.getName().endsWith(".jar")) continue;
            coreModList.add(file);
        }
        coreModList = Arrays.asList(FileListHelper.sortFileList((File[])coreModList.toArray(new File[coreModList.size()])));
        for (File file : coreModList) {
            String cascadedTweaker;
            String cfg;
            Attributes mfAttributes;
            JarFile jar;
            block29: {
                FMLRelaunchLog.fine((String)"Examining for coremod candidacy %s", (Object[])new Object[]{file.getName()});
                jar = null;
                try {
                    jar = new JarFile(file);
                    if (jar.getManifest() == null) continue;
                    mfAttributes = jar.getManifest().getMainAttributes();
                    String ats = mfAttributes.getValue(ModAccessTransformer.FMLAT);
                    if (ats == null || ats.isEmpty()) break block29;
                    if (jar == null) {
                        jar = new JarFile(file);
                    }
                    ModAccessTransformer.addJar((JarFile)jar, (String)ats);
                }
                catch (IOException ioe) {
                    FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)ioe, (String)"Unable to read the jar file %s - ignoring", (Object[])new Object[]{file.getName()});
                    continue;
                }
                finally {
                    if (jar == null) continue;
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            if (mfAttributes.getValue("AccessTransformer") != null) {
                cfg = mfAttributes.getValue("AccessTransformer");
                ((List)transformers.get(classLoader)).add(new AccessTransformer(cfg){});
            }
            if (mfAttributes.getValue("FMLAT") != null) {
                cfg = "META-INF/" + mfAttributes.getValue("FMLAT");
                ((List)transformers.get(classLoader)).add(new AccessTransformer(cfg){});
            }
            if ((cascadedTweaker = mfAttributes.getValue("TweakClass")) != null) {
                FMLRelaunchLog.info((String)"Loading tweaker %s from %s", (Object[])new Object[]{cascadedTweaker, file.getName()});
                Integer sortOrder = Ints.tryParse((String)Strings.nullToEmpty((String)mfAttributes.getValue("TweakOrder")));
                sortOrder = sortOrder == null ? Integer.valueOf(0) : sortOrder;
                handleCascadingTweak.invoke(null, file, jar, cascadedTweaker, classLoader, sortOrder);
                ((List)loadedCoremods.get(null)).add(file.getName());
                continue;
            }
            String fmlCorePlugin = mfAttributes.getValue("FMLCorePlugin");
            if (fmlCorePlugin == null) {
                FMLRelaunchLog.fine((String)"Not found coremod data in %s", (Object[])new Object[]{file.getName()});
                continue;
            }
            if (!mfAttributes.containsKey(COREMODCONTAINSFMLMOD)) {
                FMLRelaunchLog.finer((String)"Adding %s to the list of known coremods, it will not be examined again", (Object[])new Object[]{file.getName()});
                ((List)loadedCoremods.get(null)).add(file.getName());
            } else {
                FMLRelaunchLog.finer((String)"Found FMLCorePluginContainsFMLMod marker in %s, it will be examined later for regular @Mod instances", (Object[])new Object[]{file.getName()});
            }
            loadCoreMod.invoke(null, classLoader, fmlCorePlugin, file);
        }
        try {
            URL resource = Resources.getResource((String)"CoFH_at.cfg");
            if (resource != null) {
                AccessTransformer accessTransformer = new AccessTransformer("CoFH_at.cfg"){};
                DevEnvHelper.insertTransformer((IClassTransformer)accessTransformer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void insertTransformer(IClassTransformer transformer) {
        Field fTransformers = LaunchClassLoader.class.getDeclaredField("transformers");
        fTransformers.setAccessible(true);
        List transformerList = (List)fTransformers.get(Launch.classLoader);
        transformerList.add(transformer);
    }

    public static void handleSpecialClassTransformer() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, IOException, MappingLoader_MCP.CantLoadMCPMappingException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Object modses;
        if (!DevEnvHelper.isDevelopmentEnvironment() || !new File(".mcpMappings").exists()) {
            return;
        }
        m = new MappingLoader_MCP("1.7.10", MinecraftNameSet.Side.UNIVERSAL, new File(".mcpMappings")).getForwardCSV();
        Field ucpF = URLClassLoader.class.getDeclaredField("ucp");
        ucpF.setAccessible(true);
        Object ucp = ucpF.get(Launch.classLoader);
        Field pathF = ucp.getClass().getDeclaredField("path");
        Field loadersF = ucp.getClass().getDeclaredField("loaders");
        Method addURL = ucp.getClass().getMethod("addURL", URL.class);
        pathF.setAccessible(true);
        loadersF.setAccessible(true);
        addURL.setAccessible(true);
        ArrayList modFileList = new ArrayList();
        File modsFolder = new File("mods");
        if (modsFolder.exists() && (modses = modsFolder.listFiles()) != null) {
            Collections.addAll(modFileList, modses);
        }
        for (File f : modFileList) {
            String path;
            if (!f.isFile() || !(path = f.getAbsolutePath()).endsWith("LP_DEOBF.jar")) continue;
            URL toMove = f.toURI().toURL();
            addURL.invoke(ucp, toMove);
            Enumeration tmp = Launch.classLoader.findResources("notToBeFound");
            while (tmp.hasMoreElements()) {
                tmp.nextElement();
            }
            List pathes = (List)pathF.get(ucp);
            List loaders = (List)loadersF.get(ucp);
            Object toMoveLoaders = null;
            Class<?> loaderClass = Class.forName("sun.misc.URLClassPath$Loader");
            for (Object loader : loaders) {
                Field baseF = loaderClass.getDeclaredField("base");
                baseF.setAccessible(true);
                URL base = (URL)baseF.get(loader);
                if (!base.toExternalForm().contains(toMove.toExternalForm())) continue;
                toMoveLoaders = loader;
                break;
            }
            Object toMovepathes = pathes.get(loaders.indexOf(toMoveLoaders));
            for (int i = loaders.indexOf(toMoveLoaders); i > 0; --i) {
                loaders.set(i, loaders.get(i - 1));
                pathes.set(i, pathes.get(i - 1));
            }
            loaders.set(0, toMoveLoaders);
            pathes.set(0, toMovepathes);
        }
        Field fTransformers = LaunchClassLoader.class.getDeclaredField("transformers");
        fTransformers.setAccessible(true);
        List transformers = (List)fTransformers.get(Launch.classLoader);
        transformers.add(transformer);
        for (int i = transformers.size() - 1; i > 0; --i) {
            transformers.set(i, transformers.get(i - 1));
        }
        transformers.set(0, transformer);
    }

    private static void processAnnotationList(Mapping m, List<AnnotationNode>[] array) {
        if (array != null) {
            for (List<AnnotationNode> list : array) {
                DevEnvHelper.processAnnotationList(m, list);
            }
        }
    }

    private static void processAnnotationList(Mapping m, List<AnnotationNode> list) {
        if (list != null) {
            for (AnnotationNode an : list) {
                DevEnvHelper.processAnnotation(m, an);
            }
        }
    }

    private static void processAnnotation(Mapping m, AnnotationNode an) {
        an.desc = m.getClass(an.desc);
        if (an.values != null) {
            for (int k = 1; k < an.values.size(); k += 2) {
                an.values.set(k, DevEnvHelper.processAnnotationValue(m, an.values.get(k)));
            }
        }
    }

    private static Object processAnnotationValue(Mapping m, Object value) {
        if (value instanceof Type) {
            return Type.getType((String)m.getClass(((Type)value).getDescriptor()));
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            String desc = array[0];
            String enumvalue = array[1];
            if (!desc.startsWith("L") || !desc.endsWith(";")) {
                throw new AssertionError((Object)("Not a class type descriptor: " + desc));
            }
            return new String[]{m.getClass(desc), m.getField(desc.substring(1, desc.length() - 1), enumvalue)};
        }
        if (value instanceof List) {
            List list = (List)value;
            for (int k = 0; k < list.size(); ++k) {
                list.set(k, DevEnvHelper.processAnnotationValue(m, list.get(k)));
            }
            return value;
        }
        if (value instanceof AnnotationNode) {
            DevEnvHelper.processAnnotation(m, (AnnotationNode)value);
            return value;
        }
        return value;
    }

    private static String resolveField(String owner, String name, String desc, Mapping m) throws IOException {
        if (owner == null) {
            return null;
        }
        byte[] bytes = Launch.classLoader.getClassBytes(owner);
        if (bytes == null) {
            return null;
        }
        ClassNode cn = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)cn, 0);
        for (FieldNode fn : cn.fields) {
            String newName = m.getField(owner, name);
            String newDesc = m.mapTypeDescriptor(desc);
            if (!fn.name.equals(newName) || !fn.desc.equals(newDesc)) continue;
            return owner;
        }
        for (String i : cn.interfaces) {
            String result = DevEnvHelper.resolveField(i, name, desc, m);
            if (result == null) continue;
            return result;
        }
        return DevEnvHelper.resolveField(cn.superName, name, desc, m);
    }

    private static String[] resolveMethod(String owner, String name, String desc, Mapping m) throws IOException {
        if (owner == null) {
            return null;
        }
        byte[] bytes = Launch.classLoader.getClassBytes(owner);
        if (bytes == null) {
            return null;
        }
        ClassNode cn = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)cn, 0);
        if ((cn.access & 0x200) != 0) {
            for (MethodNode mn : cn.methods) {
                if (!mn.name.equals(name) || !mn.desc.equals(desc) || m.getMethod(owner, name, desc).equals(name)) continue;
                return new String[]{owner, desc};
            }
            for (String i : cn.interfaces) {
                String[] result = DevEnvHelper.resolveMethod(i, name, desc, m);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        String originalOwner = owner;
        while (owner != null && (bytes = Launch.classLoader.getClassBytes(owner)) != null) {
            cn = new ClassNode();
            reader = new ClassReader(bytes);
            reader.accept((ClassVisitor)cn, 0);
            for (MethodNode mn : cn.methods) {
                if (!mn.name.equals(name) || !mn.desc.equals(desc) || m.getMethod(owner, name, desc).equals(name)) continue;
                return new String[]{owner, desc};
            }
            owner = cn.superName;
        }
        owner = originalOwner;
        while (owner != null && (bytes = Launch.classLoader.getClassBytes(owner)) != null) {
            cn = new ClassNode();
            reader = new ClassReader(bytes);
            reader.accept((ClassVisitor)cn, 0);
            for (String i : cn.interfaces) {
                String[] result = DevEnvHelper.resolveMethod(i, name, desc, m);
                if (result == null) continue;
                return result;
            }
            owner = cn.superName;
        }
        return null;
    }

    static {
        transformer = new IClassTransformer(){

            public byte[] transform(String name, String transformedName, byte[] basicClass) {
                try {
                    return this.transform_Sub(name, transformedName, basicClass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return basicClass;
                }
            }

            public byte[] transform_Sub(String name, String transformedName, byte[] basicClass) throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
                if (basicClass == null) {
                    return basicClass;
                }
                String resourcePath = name.replace('.', '/').concat(".class");
                URL classResource = Launch.classLoader.findResource(resourcePath);
                String path = classResource.getPath().toString();
                if (path.contains("LP_DEOBF.jar!/")) {
                    ClassNode cn = new ClassNode();
                    ClassReader reader = new ClassReader(basicClass);
                    reader.accept((ClassVisitor)cn, 0);
                    for (MethodNode mn : cn.methods) {
                        String[] resolvedMN = DevEnvHelper.resolveMethod(cn.name, mn.name, mn.desc, m);
                        if (resolvedMN != null) {
                            mn.name = m.getMethod(resolvedMN[0], mn.name, resolvedMN[1]);
                            mn.desc = m.mapMethodDescriptor(resolvedMN[1]);
                        } else {
                            mn.name = m.getMethod(cn.name, mn.name, mn.desc);
                            mn.desc = m.mapMethodDescriptor(mn.desc);
                        }
                        if (mn.instructions != null) {
                            for (AbstractInsnNode ain = mn.instructions.getFirst(); ain != null; ain = ain.getNext()) {
                                MethodInsnNode min;
                                if (ain instanceof FieldInsnNode) {
                                    FieldInsnNode fin = (FieldInsnNode)ain;
                                    String realOwner = DevEnvHelper.resolveField(fin.owner, fin.name, fin.desc, m);
                                    if (realOwner == null) {
                                        realOwner = fin.owner;
                                    }
                                    fin.name = m.getField(realOwner, fin.name);
                                    fin.desc = m.mapTypeDescriptor(fin.desc);
                                    fin.owner = m.getClass(realOwner);
                                    continue;
                                }
                                if (ain instanceof FrameNode) {
                                    FrameNode fn = (FrameNode)ain;
                                    if (fn.local != null) {
                                        for (int k = 0; k < fn.local.size(); ++k) {
                                            if (!(fn.local.get(k) instanceof String)) continue;
                                            fn.local.set(k, m.getClass((String)fn.local.get(k)));
                                        }
                                    }
                                    if (fn.stack == null) continue;
                                    for (int k = 0; k < fn.stack.size(); ++k) {
                                        if (!(fn.stack.get(k) instanceof String)) continue;
                                        fn.stack.set(k, m.getClass((String)fn.stack.get(k)));
                                    }
                                    continue;
                                }
                                if (ain instanceof MethodInsnNode) {
                                    min = (MethodInsnNode)ain;
                                    String[] realOwnerAndDesc = DevEnvHelper.resolveMethod(min.owner, min.name, min.desc, m);
                                    String realOwner = realOwnerAndDesc == null ? min.owner : realOwnerAndDesc[0];
                                    String realDesc = realOwnerAndDesc == null ? min.desc : realOwnerAndDesc[1];
                                    min.name = m.getMethod(realOwner, min.name, realDesc);
                                    min.owner = m.getClass(min.owner);
                                    min.desc = m.mapMethodDescriptor(realDesc);
                                    continue;
                                }
                                if (ain instanceof LdcInsnNode) {
                                    LdcInsnNode lin = (LdcInsnNode)ain;
                                    if (!(lin.cst instanceof Type)) continue;
                                    lin.cst = Type.getType((String)m.mapTypeDescriptor(((Type)lin.cst).getDescriptor()));
                                    continue;
                                }
                                if (ain instanceof TypeInsnNode) {
                                    TypeInsnNode tin = (TypeInsnNode)ain;
                                    tin.desc = m.getClass(tin.desc);
                                    continue;
                                }
                                if (!(ain instanceof MultiANewArrayInsnNode)) continue;
                                min = (MultiANewArrayInsnNode)ain;
                                min.desc = m.getClass(min.desc);
                            }
                        }
                        DevEnvHelper.processAnnotationList(m, mn.visibleAnnotations);
                        DevEnvHelper.processAnnotationList(m, mn.visibleParameterAnnotations);
                        DevEnvHelper.processAnnotationList(m, mn.invisibleAnnotations);
                        DevEnvHelper.processAnnotationList(m, mn.invisibleParameterAnnotations);
                        mn.tryCatchBlocks.stream().filter(tcb -> tcb.type != null).forEach(tcb -> {
                            tcb.type = m.getClass(tcb.type);
                        });
                        HashSet<String> exceptions = new HashSet<String>(mn.exceptions);
                        exceptions.addAll(m.getExceptions(cn.name, mn.name, mn.desc));
                        mn.exceptions.clear();
                        mn.exceptions.addAll(exceptions.stream().map(s -> m.getClass((String)s)).collect(Collectors.toList()));
                        if (mn.localVariables == null) continue;
                        for (LocalVariableNode lvn : mn.localVariables) {
                            lvn.desc = m.mapTypeDescriptor(lvn.desc);
                        }
                    }
                    for (FieldNode fn : cn.fields) {
                        fn.name = m.getField(cn.name, fn.name);
                        fn.desc = m.mapTypeDescriptor(fn.desc);
                        DevEnvHelper.processAnnotationList(m, fn.invisibleAnnotations);
                        DevEnvHelper.processAnnotationList(m, fn.visibleAnnotations);
                    }
                    cn.name = m.getClass(cn.name);
                    cn.superName = m.getClass(cn.superName);
                    for (int k = 0; k < cn.interfaces.size(); ++k) {
                        cn.interfaces.set(k, m.getClass((String)cn.interfaces.get(k)));
                    }
                    DevEnvHelper.processAnnotationList(m, cn.invisibleAnnotations);
                    DevEnvHelper.processAnnotationList(m, cn.visibleAnnotations);
                    for (InnerClassNode icn : cn.innerClasses) {
                        icn.name = m.getClass(icn.name);
                        if (icn.outerName == null) continue;
                        icn.outerName = m.getClass(icn.outerName);
                    }
                    if (cn.outerMethod != null) {
                        String[] resolved = DevEnvHelper.resolveMethod(cn.outerClass, cn.outerMethod, cn.outerMethodDesc, m);
                        if (resolved != null) {
                            cn.outerMethod = m.getMethod(resolved[0], cn.outerMethod, resolved[1]);
                            cn.outerMethodDesc = m.mapMethodDescriptor(resolved[1]);
                        } else {
                            cn.outerMethod = m.getMethod(cn.outerClass, cn.outerMethod, cn.outerMethodDesc);
                            cn.outerMethodDesc = m.mapMethodDescriptor(cn.outerMethodDesc);
                        }
                    }
                    if (cn.outerClass != null) {
                        cn.outerClass = m.getClass(cn.outerClass);
                    }
                    ClassWriter writer = new ClassWriter(0);
                    cn.accept((ClassVisitor)writer);
                    return writer.toByteArray();
                }
                return basicClass;
            }
        };
    }

    public static class SrgFile {
        public Map<String, String> classes = new HashMap<String, String>();
        public Map<String, String> fields = new HashMap<String, String>();
        public Map<String, String> methods = new HashMap<String, String>();

        public static String getLastComponent(String s) {
            String[] parts = s.split("/");
            return parts[parts.length - 1];
        }

        private SrgFile() {
        }

        public static SrgFile read(Reader r, boolean reverse) throws IOException {
            Scanner in = new Scanner(r);
            SrgFile rv = new SrgFile();
            while (in.hasNextLine()) {
                String deobf;
                String obf;
                if (in.hasNext("CL:")) {
                    in.next();
                    obf = in.next();
                    deobf = in.next();
                    if (reverse) {
                        rv.classes.put(deobf, obf);
                        continue;
                    }
                    rv.classes.put(obf, deobf);
                    continue;
                }
                if (in.hasNext("FD:")) {
                    in.next();
                    obf = in.next();
                    deobf = in.next();
                    if (reverse) {
                        rv.fields.put(deobf, SrgFile.getLastComponent(obf));
                        continue;
                    }
                    rv.fields.put(obf, SrgFile.getLastComponent(deobf));
                    continue;
                }
                if (in.hasNext("MD:")) {
                    in.next();
                    obf = in.next();
                    String obfdesc = in.next();
                    String deobf2 = in.next();
                    String deobfdesc = in.next();
                    if (reverse) {
                        rv.methods.put(deobf2 + deobfdesc, SrgFile.getLastComponent(obf));
                        continue;
                    }
                    rv.methods.put(obf + obfdesc, SrgFile.getLastComponent(deobf2));
                    continue;
                }
                in.nextLine();
            }
            return rv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public SrgFile(File f, boolean reverse) throws IOException {
            try (FileReader fr = new FileReader(f);){
                SrgFile sf = SrgFile.read(new BufferedReader(fr), reverse);
                this.classes = sf.classes;
                this.fields = sf.fields;
                this.methods = sf.methods;
            }
        }

        public Mapping toMapping(NameSet fromNS, NameSet toNS) {
            int i;
            Mapping m = new Mapping(fromNS, toNS);
            for (Map.Entry<String, String> entry : this.classes.entrySet()) {
                m.setClass(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                i = entry.getKey().lastIndexOf(47);
                m.setField(entry.getKey().substring(0, i), entry.getKey().substring(i + 1), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.methods.entrySet()) {
                i = entry.getKey().lastIndexOf(40);
                String desc = entry.getKey().substring(i);
                String classandname = entry.getKey().substring(0, i);
                i = classandname.lastIndexOf(47);
                m.setMethod(classandname.substring(0, i), classandname.substring(i + 1), desc, entry.getValue());
            }
            return m;
        }
    }

    public static class ExcFile {
        public Map<String, String[]> exceptions = new HashMap<String, String[]>();
        private static String[] EMPTY_STRING_ARRAY = new String[0];

        public String[] getExceptionClasses(String clazz, String func, String desc) {
            String[] r = this.exceptions.get(clazz + "/" + func + desc);
            if (r == null) {
                return EMPTY_STRING_ARRAY;
            }
            return r;
        }

        private ExcFile() {
        }

        public static ExcFile read(InputStream in) throws IOException {
            return ExcFile.read(new InputStreamReader(in, StandardCharsets.UTF_8));
        }

        public static ExcFile read(Reader r) throws IOException {
            ExcFile rv = new ExcFile();
            Scanner in = new Scanner(r);
            while (in.hasNextLine()) {
                int i;
                String line = in.nextLine();
                if (line.startsWith("#") || line.contains("-Access=") || line.contains("=CL_") || (i = line.indexOf(46)) < 0) continue;
                String clazz = line.substring(0, i);
                line = line.substring(i + 1);
                i = line.indexOf(40);
                String func = line.substring(0, i);
                line = line.substring(i + 1);
                i = line.indexOf(61);
                String desc = line.substring(0, i);
                line = line.substring(i + 1);
                i = line.indexOf(124);
                String excs = line.substring(0, i);
                line = line.substring(i + 1);
                if (excs.contains("CL_")) {
                    throw new RuntimeException(excs);
                }
                rv.exceptions.put(clazz + "/" + func + desc, excs.split(","));
            }
            return rv;
        }

        @Deprecated
        public ExcFile(File f) throws IOException {
            try (FileReader fr = new FileReader(f);){
                this.exceptions = ExcFile.read((Reader)fr).exceptions;
            }
        }
    }

    public static abstract class CsvFile {
        public static Map<String, String> read(Reader r, int[] n_sides) throws IOException {
            HashMap<String, String> data = new HashMap<String, String>();
            Scanner in = new Scanner(r);
            in.useDelimiter(",");
            while (in.hasNextLine()) {
                String searge = in.next();
                String name = in.next();
                String side = in.next();
                in.nextLine();
                try {
                    if (!CsvFile.sideIn(Integer.parseInt(side), n_sides)) continue;
                    data.put(searge, name);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public static Map<String, String> read(File f, int[] n_sides) throws IOException {
            try (BufferedReader r = new BufferedReader(new FileReader(f));){
                Map<String, String> map = CsvFile.read(r, n_sides);
                return map;
            }
        }

        private static boolean sideIn(int i, int[] ar) {
            for (int n : ar) {
                if (n != i) continue;
                return true;
            }
            return false;
        }
    }

    public static class MappingLoader_MCP {
        private Mapping forwardSRG;
        private Mapping reverseSRG;
        private Mapping forwardCSV;
        private Mapping reverseCSV;
        private Map<String, Set<String>> srgMethodOwnersAndDescs = new HashMap<String, Set<String>>();
        private Map<String, Set<String>> srgFieldOwners = new HashMap<String, Set<String>>();
        private ExcFile excFileData;

        public MappingLoader_MCP() {
        }

        @Deprecated
        public MappingLoader_MCP(String mcVer, MinecraftNameSet.Side side, File mcpDir) throws IOException, CantLoadMCPMappingException {
            File excFile;
            File srgFile;
            int[] sideNumbers;
            switch (side) {
                case UNIVERSAL: {
                    sideNumbers = new int[]{2, 1, 0};
                    if (new File(mcpDir, "packaged.srg").exists()) {
                        srgFile = new File(mcpDir, "packaged.srg");
                        excFile = new File(mcpDir, "packaged.exc");
                        break;
                    }
                    srgFile = new File(mcpDir, "joined.srg");
                    excFile = new File(mcpDir, "joined.exc");
                    break;
                }
                case CLIENT: {
                    sideNumbers = new int[]{0};
                    srgFile = new File(mcpDir, "client.srg");
                    if (new File(mcpDir, "joined.exc").exists()) {
                        excFile = new File(mcpDir, "joined.exc");
                        break;
                    }
                    excFile = new File(mcpDir, "client.exc");
                    break;
                }
                case SERVER: {
                    sideNumbers = new int[]{1};
                    srgFile = new File(mcpDir, "server.srg");
                    if (new File(mcpDir, "joined.exc").exists()) {
                        excFile = new File(mcpDir, "joined.exc");
                        break;
                    }
                    excFile = new File(mcpDir, "server.exc");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("side is " + (Object)((Object)side)));
                }
            }
            this.load(side, mcVer, new ExcFile(excFile), new SrgFile(srgFile, false), CsvFile.read(new File(mcpDir, "fields.csv"), sideNumbers), CsvFile.read(new File(mcpDir, "methods.csv"), sideNumbers));
        }

        public void load(MinecraftNameSet.Side side, String mcVer, ExcFile excFile, SrgFile srgFile, Map<String, String> fieldNames, Map<String, String> methodNames) throws CantLoadMCPMappingException {
            MinecraftNameSet obfNS = new MinecraftNameSet(MinecraftNameSet.Type.OBF, side, mcVer);
            MinecraftNameSet srgNS = new MinecraftNameSet(MinecraftNameSet.Type.SRG, side, mcVer);
            MinecraftNameSet mcpNS = new MinecraftNameSet(MinecraftNameSet.Type.MCP, side, mcVer);
            this.forwardSRG = new Mapping(obfNS, srgNS);
            this.reverseSRG = new Mapping(srgNS, obfNS);
            this.forwardCSV = new Mapping(srgNS, mcpNS);
            this.reverseCSV = new Mapping(mcpNS, srgNS);
            this.excFileData = excFile;
            this.loadSRGMapping(srgFile);
            this.loadCSVMapping(fieldNames, methodNames);
        }

        private void loadSRGMapping(SrgFile srg) throws CantLoadMCPMappingException {
            String srgName;
            this.forwardSRG.setDefaultPackage("net/minecraft/src/");
            this.reverseSRG.addPrefix("net/minecraft/src/", "");
            for (Map.Entry<String, String> entry : srg.classes.entrySet()) {
                String obfClass = entry.getKey();
                String srgClass = entry.getValue();
                this.forwardSRG.setClass(obfClass, srgClass);
                this.reverseSRG.setClass(srgClass, obfClass);
            }
            for (Map.Entry<String, String> entry : srg.fields.entrySet()) {
                String obfOwnerAndName = entry.getKey();
                srgName = entry.getValue();
                String obfOwner = obfOwnerAndName.substring(0, obfOwnerAndName.lastIndexOf(47));
                String obfName = obfOwnerAndName.substring(obfOwnerAndName.lastIndexOf(47) + 1);
                String srgOwner = srg.classes.get(obfOwner);
                if (srgName.startsWith("field_")) {
                    Set<String> owners;
                    if (this.srgFieldOwners.containsKey(srgName)) {
                        System.out.println("SRG field " + srgName + " appears in multiple classes (at least " + this.srgFieldOwners.get(srgName) + " and " + srgOwner + ")");
                    }
                    if ((owners = this.srgFieldOwners.get(srgName)) == null) {
                        owners = new HashSet<String>();
                        this.srgFieldOwners.put(srgName, owners);
                    }
                    owners.add(srgOwner);
                }
                this.forwardSRG.setField(obfOwner, obfName, srgName);
                this.reverseSRG.setField(srgOwner, srgName, obfName);
            }
            for (Map.Entry<String, String> entry : srg.methods.entrySet()) {
                String obfOwnerNameAndDesc = entry.getKey();
                srgName = entry.getValue();
                String obfOwnerAndName = obfOwnerNameAndDesc.substring(0, obfOwnerNameAndDesc.indexOf(40));
                String obfOwner = obfOwnerAndName.substring(0, obfOwnerAndName.lastIndexOf(47));
                String obfName = obfOwnerAndName.substring(obfOwnerAndName.lastIndexOf(47) + 1);
                String obfDesc = obfOwnerNameAndDesc.substring(obfOwnerNameAndDesc.indexOf(40));
                String srgDesc = this.forwardSRG.mapMethodDescriptor(obfDesc);
                String srgOwner = srg.classes.get(obfOwner);
                Set<String> srgMethodOwnersThis = this.srgMethodOwnersAndDescs.get(srgName);
                if (srgMethodOwnersThis == null) {
                    srgMethodOwnersThis = new HashSet<String>();
                    this.srgMethodOwnersAndDescs.put(srgName, srgMethodOwnersThis);
                }
                srgMethodOwnersThis.add(srgOwner + srgDesc);
                this.forwardSRG.setMethod(obfOwner, obfName, obfDesc, srgName);
                this.reverseSRG.setMethod(srgOwner, srgName, srgDesc, obfName);
                String[] srgExceptions = this.excFileData.getExceptionClasses(srgOwner, srgName, srgDesc);
                if (srgExceptions.length <= 0) continue;
                ArrayList<String> obfExceptions = new ArrayList<String>();
                for (String s : srgExceptions) {
                    obfExceptions.add(this.reverseSRG.getClass(s));
                }
                this.forwardSRG.setExceptions(obfOwner, obfName, obfDesc, obfExceptions);
            }
        }

        private void loadCSVMapping(Map<String, String> fieldNames, Map<String, String> methodNames) throws CantLoadMCPMappingException {
            String mcpName;
            String srgName;
            for (Map.Entry<String, String> entry : fieldNames.entrySet()) {
                srgName = entry.getKey();
                mcpName = entry.getValue();
                if (this.srgFieldOwners.get(srgName) == null) {
                    System.out.println("Field exists in CSV but not in SRG: " + srgName + " (CSV name: " + mcpName + ")");
                    continue;
                }
                Iterator<String> iterator = this.srgFieldOwners.get(srgName).iterator();
                while (iterator.hasNext()) {
                    String srgOwner;
                    String mcpOwner = srgOwner = iterator.next();
                    this.forwardCSV.setField(srgOwner, srgName, mcpName);
                    this.reverseCSV.setField(mcpOwner, mcpName, srgName);
                }
            }
            for (Map.Entry<String, String> entry : methodNames.entrySet()) {
                srgName = entry.getKey();
                mcpName = entry.getValue();
                if (this.srgMethodOwnersAndDescs.get(srgName) == null) {
                    System.out.println("Method exists in CSV but not in SRG: " + srgName + " (CSV name: " + mcpName + ")");
                    continue;
                }
                for (String srgOwnerAndDesc : this.srgMethodOwnersAndDescs.get(srgName)) {
                    String srgOwner;
                    String srgDesc = srgOwnerAndDesc.substring(srgOwnerAndDesc.indexOf(40));
                    String mcpOwner = srgOwner = srgOwnerAndDesc.substring(0, srgOwnerAndDesc.indexOf(40));
                    String mcpDesc = srgDesc;
                    this.forwardCSV.setMethod(srgOwner, srgName, srgDesc, mcpName);
                    this.reverseCSV.setMethod(mcpOwner, mcpName, mcpDesc, srgName);
                }
            }
        }

        public Mapping getReverseSRG() {
            return this.reverseSRG;
        }

        public Mapping getReverseCSV() {
            return this.reverseCSV;
        }

        public Mapping getForwardSRG() {
            return this.forwardSRG;
        }

        public Mapping getForwardCSV() {
            return this.forwardCSV;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getMCVer(File mcpDir) throws IOException {
            try (Scanner in = new Scanner(new File(mcpDir, "version.cfg"));){
                while (in.hasNextLine()) {
                    String line = in.nextLine();
                    if (!line.startsWith("ClientVersion")) continue;
                    String string = line.split("=")[1].trim();
                    return string;
                }
                String string = "unknown";
                return string;
            }
        }

        public static class CantLoadMCPMappingException
        extends Exception {
            private static final long serialVersionUID = 1L;

            public CantLoadMCPMappingException(String reason) {
                super(reason);
            }
        }
    }

    public static class MinecraftNameSet
    extends NameSet {
        public final Type type;
        public final String mcVersion;
        public final Side side;

        public MinecraftNameSet(Type type, Side side, String mcVersion) {
            this.type = type;
            this.side = side;
            this.mcVersion = mcVersion;
        }

        @Override
        public boolean equals(Object obj) {
            try {
                MinecraftNameSet ns = (MinecraftNameSet)obj;
                return ns.type == this.type && ns.side == this.side && ns.mcVersion.equals(this.mcVersion);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return (this.side.ordinal() << 8) + this.type.ordinal() + this.mcVersion.hashCode();
        }

        @Override
        public String toString() {
            return this.mcVersion + " " + (Object)((Object)this.type) + " " + (Object)((Object)this.side);
        }

        public static enum Side {
            UNIVERSAL,
            CLIENT,
            SERVER;

        }

        public static enum Type {
            OBF,
            SRG,
            MCP;

        }
    }

    public static abstract class NameSet {
        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        public abstract String toString();
    }

    public static class Mapping {
        private Map<String, String> classes = new HashMap<String, String>();
        private Map<String, String> methods = new HashMap<String, String>();
        private Map<String, String> fields = new HashMap<String, String>();
        private Map<String, List<String>> exceptions = new HashMap<String, List<String>>();
        private Map<String, String> classPrefixes = new HashMap<String, String>();
        private String defaultPackage = "";
        public final NameSet fromNS;
        public final NameSet toNS;

        public Mapping(NameSet fromNS, NameSet toNS) {
            this.fromNS = fromNS;
            this.toNS = toNS;
        }

        public void setClass(String in, String out) {
            this.classes.put(in, out);
        }

        public void setMethod(String clazz, String name, String desc, String out) {
            this.methods.put(clazz + "/" + name + desc, out);
        }

        public void setField(String clazz, String name, String out) {
            this.fields.put(clazz + "/" + name, out);
        }

        public void setExceptions(String clazz, String method, String desc, List<String> exc) {
            this.exceptions.put(clazz + "/" + method + desc, exc);
        }

        public String getClass(String in) {
            if (in == null) {
                return null;
            }
            if (in.startsWith("[L") && in.endsWith(";")) {
                return "[L" + this.getClass(in.substring(2, in.length() - 1)) + ";";
            }
            if (in.startsWith("[")) {
                return "[" + this.getClass(in.substring(1));
            }
            if (in.equals("B") || in.equals("C") || in.equals("D") || in.equals("F") || in.equals("I") || in.equals("J") || in.equals("S") || in.equals("Z")) {
                return in;
            }
            String ret = this.classes.get(in);
            if (ret != null) {
                return ret;
            }
            for (Map.Entry<String, String> e : this.classPrefixes.entrySet()) {
                if (!in.startsWith(e.getKey())) continue;
                return e.getValue() + in.substring(e.getKey().length());
            }
            if (!in.contains("/")) {
                return this.defaultPackage + in;
            }
            return in;
        }

        public String getMethod(String clazz, String name, String desc) {
            String ret = this.methods.get(clazz + "/" + name + desc);
            return ret == null ? name : ret;
        }

        public String getField(String clazz, String name) {
            String ret = this.fields.get(clazz + "/" + name);
            return ret == null ? name : ret;
        }

        public List<String> getExceptions(String clazz, String method, String desc) {
            List<String> ret = this.exceptions.get(clazz + "/" + method + desc);
            return ret == null ? Collections.emptyList() : ret;
        }

        public void addPrefix(String old, String new_) {
            this.classPrefixes.put(old, new_);
        }

        public void setDefaultPackage(String p) {
            this.defaultPackage = p;
        }

        public String mapMethodDescriptor(String desc) {
            if (desc.length() == 0 || desc.charAt(0) != '(' || desc.indexOf(")") < 1) {
                throw new IllegalArgumentException("Not a valid method descriptor: " + desc);
            }
            int pos = 0;
            String out = "";
            block4: while (pos < desc.length()) {
                switch (desc.charAt(pos)) {
                    case '(': 
                    case ')': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'V': 
                    case 'Z': 
                    case '[': {
                        out = out + desc.charAt(pos);
                        ++pos;
                        continue block4;
                    }
                    case 'L': {
                        int end = desc.indexOf(59, pos);
                        String obf = desc.substring(pos + 1, end);
                        pos = end + 1;
                        out = out + "L" + this.getClass(obf) + ";";
                        continue block4;
                    }
                }
                throw new RuntimeException("Unknown method descriptor character: " + desc.charAt(pos) + " (in " + desc + ")");
            }
            return out;
        }

        public String mapTypeDescriptor(String in) {
            if (in.startsWith("[")) {
                return "[" + this.mapTypeDescriptor(in.substring(1));
            }
            if (in.startsWith("L") && in.endsWith(";")) {
                return "L" + this.getClass(in.substring(1, in.length() - 1)) + ";";
            }
            return in;
        }
    }
}

