/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.powertile;

import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import logisticspipes.asm.ModDependentInterface;
import logisticspipes.asm.ModDependentMethod;
import logisticspipes.blocks.powertile.LogisticsPowerProviderTileEntity;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.LogisticsHUDRenderer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

@ModDependentInterface(modId={"ic2"}, interfacePath={"ic2.api.energy.tile.IEnergySink"})
public class LogisticsIC2PowerProviderTileEntity
extends LogisticsPowerProviderTileEntity
implements IEnergySink {
    public static final int MAX_STORAGE = 40000000;
    public static final int MAX_MAXMODE = 8;
    public static final int MAX_PROVIDE_PER_TICK = 12288;
    private boolean addedToEnergyNet = false;
    private boolean init = false;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.init && !this.addedToEnergyNet) {
            SimpleServiceLocator.IC2Proxy.registerToEneryNet(this);
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
            LogisticsHUDRenderer.instance().remove(this);
        }
        if (this.addedToEnergyNet) {
            SimpleServiceLocator.IC2Proxy.unregisterToEneryNet(this);
            this.addedToEnergyNet = false;
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
            this.init = false;
        }
        if (!this.addedToEnergyNet) {
            this.init = false;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
            LogisticsHUDRenderer.instance().remove(this);
        }
        if (this.addedToEnergyNet) {
            SimpleServiceLocator.IC2Proxy.unregisterToEneryNet(this);
            this.addedToEnergyNet = false;
        }
    }

    public void addEnergy(double amount) {
        if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
            return;
        }
        this.internalStorage += amount;
        if (this.internalStorage > 4.0E7) {
            this.internalStorage = 4.0E7;
        }
        if (this.internalStorage >= (double)this.getMaxStorage()) {
            this.needMorePowerTriggerCheck = false;
        }
    }

    public double freeSpace() {
        return (double)this.getMaxStorage() - this.internalStorage;
    }

    @Override
    public int getMaxStorage() {
        this.maxMode = Math.min(8, Math.max(1, this.maxMode));
        return 40000000 / this.maxMode;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        return super.func_189515_b(nbt);
    }

    @Override
    public String getBrand() {
        return "EU";
    }

    @Override
    protected double getMaxProvidePerTick() {
        return 12288.0;
    }

    @Override
    protected void handlePower(CoreRoutedPipe pipe, double toSend) {
        pipe.handleIC2PowerArival(toSend);
    }

    @Override
    protected int getLaserColor() {
        return 0xFFFF00;
    }

    @ModDependentMethod(modId="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter tile, EnumFacing dir) {
        return true;
    }

    @ModDependentMethod(modId="ic2")
    public double getDemandedEnergy() {
        return this.freeSpace();
    }

    @ModDependentMethod(modId="ic2")
    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    @ModDependentMethod(modId="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.addEnergy(amount);
        return 0.0;
    }
}

