/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import logisticspipes.LPConstants;
import logisticspipes.LPItems;
import logisticspipes.items.ItemUpgrade;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.LogicControllerPacket;
import logisticspipes.network.packets.gui.OpenUpgradePacket;
import logisticspipes.network.packets.pipe.PipeManagerWatchingPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgradeConfig;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.ItemDisplay;
import logisticspipes.utils.gui.LogisticsBaseTabGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.string.ChatColor;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import org.lwjgl.opengl.GL11;

public class GuiPipeController
extends LogisticsBaseTabGuiScreen {
    private final String PREFIX = "gui.pipecontroller.";
    private final CoreRoutedPipe pipe;

    public GuiPipeController(EntityPlayer player, CoreRoutedPipe pipe) {
        super(180, 220);
        this.pipe = pipe;
        DummyContainer dummy = new DummyContainer(player, null, pipe.getOriginalUpgradeManager().getGuiController());
        dummy.addNormalSlotsForPlayerInventory(10, 135);
        Upgrades upgrades = new Upgrades(dummy);
        Security security = new Security(dummy);
        Statistics statistics = new Statistics();
        this.addHiddenSlot(dummy.addRestrictedSlot(0, (IInventory)pipe.container.logicController.diskInv, 14, 36, LPItems.disk));
        Tasks tasks = new Tasks();
        if (LPConstants.DEBUG) {
            this.addTab(upgrades);
            this.addTab(security);
            this.addTab(statistics);
            this.addTab(tasks);
        } else {
            this.addTab(statistics);
            this.addTab(upgrades);
            this.addTab(security);
            this.addTab(tasks);
        }
        this.field_147002_h = dummy;
    }

    private class Tasks
    extends LogisticsBaseTabGuiScreen.TabSubGui {
        private GuiButton leftButton;
        private GuiButton rightButton;
        private ItemDisplay _itemDisplay_5;
        private boolean managerWatching;

        private Tasks() {
            super(GuiPipeController.this);
        }

        @Override
        public void initTab() {
            this.leftButton = this.addButton(new SmallGuiButton(1, GuiPipeController.this.field_147003_i + 95, GuiPipeController.this.field_147009_r + 26, 10, 10, "<"));
            this.rightButton = this.addButton(new SmallGuiButton(2, GuiPipeController.this.field_147003_i + 165, GuiPipeController.this.field_147009_r + 26, 10, 10, ">"));
            if (this._itemDisplay_5 == null) {
                this._itemDisplay_5 = new ItemDisplay(null, GuiPipeController.this.field_146289_q, GuiPipeController.this, null, 10, 40, 20, 60, 0, 0, 0, new int[]{1, 1, 1, 1}, true);
            }
            this._itemDisplay_5.reposition(10, 40, 20, 60, 0, 0);
        }

        @Override
        public void renderIcon(int x, int y) {
            GuiGraphics.drawLinesBackground(GuiPipeController.this.field_146297_k, x, y);
        }

        @Override
        public void renderBackgroundContent() {
        }

        @Override
        public void leavingTab() {
            if (this.managerWatching) {
                this.managerWatching = false;
                MainProxy.sendPacketToServer(PacketHandler.getPacket(PipeManagerWatchingPacket.class).setStart(false).setTilePos(((GuiPipeController)GuiPipeController.this).pipe.container));
            }
        }

        @Override
        public void enteringTab() {
            if (!this.managerWatching) {
                this.managerWatching = true;
                MainProxy.sendPacketToServer(PacketHandler.getPacket(PipeManagerWatchingPacket.class).setStart(true).setTilePos(((GuiPipeController)GuiPipeController.this).pipe.container));
            }
        }

        @Override
        public void buttonClicked(GuiButton button) {
            if (button == this.leftButton) {
                this._itemDisplay_5.prevPage();
            } else if (button == this.rightButton) {
                this._itemDisplay_5.nextPage();
            }
        }

        @Override
        public void renderForgroundContent() {
            List _allItems = GuiPipeController.this.pipe.getClientSideOrderManager().stream().map(IOrderInfoProvider::getAsDisplayItem).collect(Collectors.toCollection(LinkedList::new));
            this._itemDisplay_5.setItemList(_allItems);
            this._itemDisplay_5.renderItemArea(GuiPipeController.this.field_73735_i);
            this._itemDisplay_5.renderPageNumber(GuiPipeController.this.right - GuiPipeController.this.field_147003_i - 45, 28);
            int start = this._itemDisplay_5.getPage() * 3;
            int stringPos = 40;
            for (int i = start; i < start + 3 && i < GuiPipeController.this.pipe.getClientSideOrderManager().size(); ++i) {
                IOrderInfoProvider order = GuiPipeController.this.pipe.getClientSideOrderManager().get(i);
                ItemIdentifier target = order.getTargetType();
                String s = "";
                if (target != null) {
                    s = target.getFriendlyName();
                    GuiPipeController.this.field_146289_q.func_78276_b(s, 35, stringPos, 0x303030);
                }
                s = Integer.toString(i + 1);
                GuiPipeController.this.field_146289_q.func_78276_b(s, 3, stringPos += 6, 0x303030);
                stringPos += 4;
                DoubleCoordinates pos = order.getTargetPosition();
                if (pos != null) {
                    s = pos.toIntBasedString();
                    GuiPipeController.this.field_146289_q.func_78276_b(s, 40, stringPos, 0x303030);
                }
                stringPos += 10;
            }
        }
    }

    private class Logic
    extends LogisticsBaseTabGuiScreen.TabSubGui {
        private GuiButton editButton;

        private Logic() {
            super(GuiPipeController.this);
        }

        @Override
        public void initTab() {
            this.editButton = this.addButton(new GuiButton(0, GuiPipeController.this.field_147003_i + 10, GuiPipeController.this.field_147009_r + 70, 160, 20, "Edit Logic Controller"));
        }

        @Override
        public void renderIcon(int x, int y) {
            GL11.glEnable((int)32826);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74520_c();
            ItemStack stack2 = new ItemStack(Blocks.field_150429_aA);
            GuiPipeController.this.field_146296_j.func_180450_b(stack2, x, y);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GuiPipeController.this.field_146296_j.field_77023_b = 0.0f;
        }

        @Override
        public void buttonClicked(GuiButton button) {
            if (button == this.editButton) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(LogicControllerPacket.class).setTilePos(((GuiPipeController)GuiPipeController.this).pipe.container));
            }
        }

        @Override
        public void renderBackgroundContent() {
            GuiPipeController.this.drawRect(GuiPipeController.this.field_147003_i + 12, GuiPipeController.this.field_147009_r + 34, GuiPipeController.this.field_147003_i + 32, GuiPipeController.this.field_147009_r + 54, Color.BLACK);
            GuiPipeController.this.drawRect(GuiPipeController.this.field_147003_i + 14, GuiPipeController.this.field_147009_r + 36, GuiPipeController.this.field_147003_i + 30, GuiPipeController.this.field_147009_r + 52, Color.DARKER_GREY);
        }

        @Override
        public void checkButton(GuiButton button, boolean isTabActive) {
            if (isTabActive) {
                button.field_146124_l = ((GuiPipeController)GuiPipeController.this).pipe.container.logicController.diskInv.func_70301_a(0) != null;
            }
            super.checkButton(button, isTabActive);
        }

        @Override
        public void renderForgroundContent() {
        }
    }

    private class Statistics
    extends LogisticsBaseTabGuiScreen.TabSubGui {
        private Statistics() {
            super(GuiPipeController.this);
        }

        @Override
        public void renderIcon(int x, int y) {
            GuiGraphics.drawStatsBackground(GuiPipeController.this.field_146297_k, x, y);
        }

        @Override
        public void renderBackgroundContent() {
        }

        @Override
        public void renderForgroundContent() {
            String pipeName = ItemIdentifier.get(((GuiPipeController)GuiPipeController.this).pipe.item, 0, null).getFriendlyName();
            GuiPipeController.this.field_146289_q.func_78276_b(pipeName, (170 - GuiPipeController.this.field_146289_q.func_78256_a(pipeName)) / 2, 28, 8609820);
            int sessionxCenter = 85;
            int lifetimexCenter = 140;
            String s = null;
            GuiPipeController.this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.Session"), sessionxCenter - GuiPipeController.this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.Session")) / 2, 40, 0x303030);
            GuiPipeController.this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.Lifetime"), lifetimexCenter - GuiPipeController.this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.Lifetime")) / 2, 40, 0x303030);
            GuiPipeController.this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.Sent") + ":", 55 - GuiPipeController.this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.Sent") + ":"), 55, 0x303030);
            GuiPipeController.this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.Recieved") + ":", 55 - GuiPipeController.this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.Recieved") + ":"), 70, 0x303030);
            GuiPipeController.this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.Relayed") + ":", 55 - GuiPipeController.this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.Relayed") + ":"), 85, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(((GuiPipeController)GuiPipeController.this).pipe.stat_session_sent);
            GuiPipeController.this.field_146289_q.func_78276_b(s, sessionxCenter - GuiPipeController.this.field_146289_q.func_78256_a(s) / 2, 55, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(((GuiPipeController)GuiPipeController.this).pipe.stat_session_recieved);
            GuiPipeController.this.field_146289_q.func_78276_b(s, sessionxCenter - GuiPipeController.this.field_146289_q.func_78256_a(s) / 2, 70, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(((GuiPipeController)GuiPipeController.this).pipe.stat_session_relayed);
            GuiPipeController.this.field_146289_q.func_78276_b(s, sessionxCenter - GuiPipeController.this.field_146289_q.func_78256_a(s) / 2, 85, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(((GuiPipeController)GuiPipeController.this).pipe.stat_lifetime_sent);
            GuiPipeController.this.field_146289_q.func_78276_b(s, lifetimexCenter - GuiPipeController.this.field_146289_q.func_78256_a(s) / 2, 55, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(((GuiPipeController)GuiPipeController.this).pipe.stat_lifetime_recieved);
            GuiPipeController.this.field_146289_q.func_78276_b(s, lifetimexCenter - GuiPipeController.this.field_146289_q.func_78256_a(s) / 2, 70, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(((GuiPipeController)GuiPipeController.this).pipe.stat_lifetime_relayed);
            GuiPipeController.this.field_146289_q.func_78276_b(s, lifetimexCenter - GuiPipeController.this.field_146289_q.func_78256_a(s) / 2, 85, 0x303030);
            GuiPipeController.this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.RoutingTableSize") + ":", 110 - GuiPipeController.this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.RoutingTableSize") + ":"), 110, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(((GuiPipeController)GuiPipeController.this).pipe.server_routing_table_size);
            GuiPipeController.this.field_146289_q.func_78276_b(s, 130 - GuiPipeController.this.field_146289_q.func_78256_a(s) / 2, 110, 0x303030);
        }
    }

    private class Security
    extends LogisticsBaseTabGuiScreen.TabSubGui {
        public Security(DummyContainer dummy) {
            super(GuiPipeController.this);
            this.addSlot(dummy.addStaticRestrictedSlot(0, (IInventory)GuiPipeController.this.pipe.getOriginalUpgradeManager().getSecInv(), 10, 42, itemStack -> {
                if (itemStack == null) {
                    return false;
                }
                if (itemStack.func_77973_b() != LPItems.itemCard) {
                    return false;
                }
                if (itemStack.func_77952_i() != 1) {
                    return false;
                }
                return SimpleServiceLocator.securityStationManager.isAuthorized(UUID.fromString(itemStack.func_77978_p().func_74779_i("UUID")));
            }, 1));
        }

        @Override
        public void renderIcon(int x, int y) {
            GuiGraphics.drawLockBackground(GuiPipeController.this.field_146297_k, x + 1, y);
        }

        @Override
        public void renderBackgroundContent() {
            GuiGraphics.drawSlotBackground(GuiPipeController.this.field_146297_k, GuiPipeController.this.field_147003_i + 9, GuiPipeController.this.field_147009_r + 41);
        }

        @Override
        public void renderForgroundContent() {
            GuiPipeController.this.field_146289_q.func_175065_a(StringUtils.translate("gui.pipecontroller.security"), 10.0f, 28.0f, Color.getValue(Color.DARKER_GREY), false);
            ItemStack itemStack = GuiPipeController.this.pipe.getOriginalUpgradeManager().getSecInv().func_70301_a(0);
            if (!itemStack.func_190926_b()) {
                UUID id = UUID.fromString(itemStack.func_77978_p().func_74779_i("UUID"));
                GuiPipeController.this.field_146289_q.func_175065_a("Id: ", 10.0f, 68.0f, Color.getValue(Color.DARKER_GREY), false);
                GL11.glTranslated((double)10.0, (double)80.0, (double)0.0);
                GL11.glScaled((double)0.75, (double)0.75, (double)1.0);
                GuiPipeController.this.field_146289_q.func_175065_a(ChatColor.BLUE.toString() + id.toString(), 0.0f, 0.0f, Color.getValue(Color.DARKER_GREY), false);
                GL11.glScaled((double)1.3333333333333333, (double)1.3333333333333333, (double)1.0);
                GL11.glTranslated((double)-10.0, (double)-80.0, (double)0.0);
                GuiPipeController.this.field_146289_q.func_175065_a("Authorization: " + (SimpleServiceLocator.securityStationManager.isAuthorized(id) ? (Object)((Object)ChatColor.GREEN) + "Authorized" : (Object)((Object)ChatColor.RED) + "Deauthorized"), 10.0f, 94.0f, Color.getValue(Color.DARKER_GREY), false);
            }
        }
    }

    private class Upgrades
    extends LogisticsBaseTabGuiScreen.TabSubGui {
        private final List<Slot> TAB_SLOTS_SNEAKY_INV;
        private final Slot[] upgradeslot;
        private GuiButton[] upgradeConfig;

        private Upgrades(DummyContainer dummy) {
            int pipeSlot;
            super(GuiPipeController.this);
            this.TAB_SLOTS_SNEAKY_INV = new ArrayList<Slot>();
            this.upgradeslot = new Slot[18];
            this.upgradeConfig = new GuiButton[18];
            for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
                this.upgradeslot[pipeSlot] = dummy.addUpgradeSlot(pipeSlot, GuiPipeController.this.pipe.getOriginalUpgradeManager(), pipeSlot, 10 + pipeSlot * 18, 42, itemStack -> {
                    if (itemStack == null) {
                        return false;
                    }
                    if (itemStack.func_77973_b() instanceof ItemUpgrade) {
                        return ((ItemUpgrade)itemStack.func_77973_b()).getUpgradeForItem(itemStack, null).isAllowedForPipe(GuiPipeController.this.pipe);
                    }
                    return false;
                });
                this.addSlot(this.upgradeslot[pipeSlot]);
            }
            for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
                Slot slot = dummy.addSneakyUpgradeSlot(pipeSlot, GuiPipeController.this.pipe.getOriginalUpgradeManager(), pipeSlot + 9, 10 + pipeSlot * 18, 88, itemStack -> {
                    if (itemStack == null) {
                        return false;
                    }
                    if (itemStack.func_77973_b() instanceof ItemUpgrade) {
                        IPipeUpgrade upgrade = ((ItemUpgrade)itemStack.func_77973_b()).getUpgradeForItem(itemStack, null);
                        if (!(upgrade instanceof SneakyUpgradeConfig)) {
                            return false;
                        }
                        return upgrade.isAllowedForPipe(GuiPipeController.this.pipe);
                    }
                    return false;
                });
                this.upgradeslot[pipeSlot + 9] = slot;
                this.TAB_SLOTS_SNEAKY_INV.add(this.addSlot(slot));
            }
        }

        @Override
        public void initTab() {
            int x = 0;
            int y = 0;
            for (int i = 0; i < this.upgradeConfig.length; ++i) {
                this.upgradeConfig[i] = this.addButton(new SmallGuiButton(20 + i, GuiPipeController.this.field_147003_i + 13 + x, GuiPipeController.this.field_147009_r + 61 + y, 10, 10, "!"));
                this.upgradeConfig[i].field_146125_m = GuiPipeController.this.pipe.getOriginalUpgradeManager().hasGuiUpgrade(i);
                if ((x += 18) <= 160 || y != 0) continue;
                x = 0;
                y = 46;
            }
        }

        @Override
        public void checkButton(GuiButton button, boolean isTabActive) {
            super.checkButton(button, isTabActive);
            for (int i = 0; i < this.upgradeConfig.length; ++i) {
                this.upgradeConfig[i].field_146125_m &= GuiPipeController.this.pipe.getOriginalUpgradeManager().hasGuiUpgrade(i);
            }
        }

        @Override
        public boolean showSlot(Slot slot) {
            return GuiPipeController.this.pipe.getOriginalUpgradeManager().hasCombinedSneakyUpgrade() || !this.TAB_SLOTS_SNEAKY_INV.contains(slot);
        }

        @Override
        public void renderIcon(int x, int y) {
            GL11.glEnable((int)32826);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74520_c();
            ItemStack stack = new ItemStack((Item)LPItems.upgrades.get(SneakyUpgradeConfig.class), 1);
            GuiPipeController.this.field_146296_j.func_180450_b(stack, x, y);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GuiPipeController.this.field_146296_j.field_77023_b = 0.0f;
        }

        @Override
        public void buttonClicked(GuiButton button) {
            for (int i = 0; i < this.upgradeConfig.length; ++i) {
                if (this.upgradeConfig[i] != button) continue;
                MainProxy.sendPacketToServer(PacketHandler.getPacket(OpenUpgradePacket.class).setSlot(this.upgradeslot[i]));
            }
        }

        @Override
        public void renderBackgroundContent() {
            int pipeSlot;
            for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
                GuiGraphics.drawSlotBackground(GuiPipeController.this.field_146297_k, GuiPipeController.this.field_147003_i + 9 + pipeSlot * 18, GuiPipeController.this.field_147009_r + 41);
            }
            if (GuiPipeController.this.pipe.getOriginalUpgradeManager().hasCombinedSneakyUpgrade()) {
                for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
                    GuiGraphics.drawSlotBackground(GuiPipeController.this.field_146297_k, GuiPipeController.this.field_147003_i + 9 + pipeSlot * 18, GuiPipeController.this.field_147009_r + 87);
                }
            }
        }

        @Override
        public void renderForgroundContent() {
            GuiPipeController.this.field_146289_q.func_175065_a(StringUtils.translate("gui.pipecontroller.upgrade"), 10.0f, 28.0f, Color.getValue(Color.DARKER_GREY), false);
            if (GuiPipeController.this.pipe.getOriginalUpgradeManager().hasCombinedSneakyUpgrade()) {
                GuiPipeController.this.field_146289_q.func_175065_a(StringUtils.translate("gui.pipecontroller.sneakyUpgrades"), 10.0f, 74.0f, Color.getValue(Color.DARKER_GREY), false);
            }
        }
    }
}

