/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logistics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import logisticspipes.LPItems;
import logisticspipes.interfaces.routing.IFluidSink;
import logisticspipes.interfaces.routing.IProvideFluids;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.logistics.ILogisticsFluidManager;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class LogisticsFluidManager
implements ILogisticsFluidManager {
    @Override
    public Pair<Integer, Integer> getBestReply(FluidIdentifierStack stack, IRouter sourceRouter, List<Integer> jamList) {
        for (ExitRoute candidateRouter : sourceRouter.getIRoutersByCost()) {
            int amount;
            CoreRoutedPipe pipe;
            if (!candidateRouter.containsFlag(PipeRoutingConnectionType.canRouteTo) || candidateRouter.destination.getSimpleID() == sourceRouter.getSimpleID() || jamList.contains(candidateRouter.destination.getSimpleID()) || candidateRouter.destination.getPipe() == null || !candidateRouter.destination.getPipe().isEnabled() || !((pipe = candidateRouter.destination.getPipe()) instanceof IFluidSink) || (amount = ((IFluidSink)((Object)pipe)).sinkAmount(stack)) <= 0) continue;
            Pair<Integer, Integer> result = new Pair<Integer, Integer>(candidateRouter.destination.getSimpleID(), amount);
            return result;
        }
        Pair<Integer, Integer> result = new Pair<Integer, Integer>(0, 0);
        return result;
    }

    @Override
    public ItemIdentifierStack getFluidContainer(FluidIdentifierStack stack) {
        ItemStack item = new ItemStack((Item)LPItems.fluidContainer, 1);
        NBTTagCompound nbt = new NBTTagCompound();
        stack.makeFluidStack().writeToNBT(nbt);
        item.func_77982_d(nbt);
        return ItemIdentifierStack.getFromStack(item);
    }

    @Override
    public FluidIdentifierStack getFluidFromContainer(ItemIdentifierStack stack) {
        ItemStack itemStack = stack.makeNormalStack();
        if (itemStack.func_77973_b() instanceof LogisticsFluidContainer && stack.getItem().tag != null) {
            return FluidIdentifierStack.getFromStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.getItem().tag));
        }
        return null;
    }

    @Override
    public TreeSet<FluidIdentifierStack> getAvailableFluid(List<ExitRoute> validDestinations) {
        HashMap<FluidIdentifier, Integer> allAvailableItems = new HashMap<FluidIdentifier, Integer>();
        for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !(r.destination.getPipe() instanceof IProvideFluids)) continue;
            IProvideFluids provider = (IProvideFluids)((Object)r.destination.getPipe());
            Map<FluidIdentifier, Integer> allItems = provider.getAvailableFluids();
            for (Map.Entry<FluidIdentifier, Integer> liquid : allItems.entrySet()) {
                Integer amount = (Integer)allAvailableItems.get(liquid.getKey());
                if (amount == null) {
                    allAvailableItems.put(liquid.getKey(), liquid.getValue());
                    continue;
                }
                long addition = (long)amount.intValue() + (long)liquid.getValue().intValue();
                if (addition > Integer.MAX_VALUE) {
                    addition = Integer.MAX_VALUE;
                }
                allAvailableItems.put(liquid.getKey(), (int)addition);
            }
        }
        TreeSet itemIdentifierStackList = allAvailableItems.entrySet().stream().map(item -> new FluidIdentifierStack((FluidIdentifier)item.getKey(), (Integer)item.getValue())).collect(Collectors.toCollection(TreeSet::new));
        return itemIdentifierStackList;
    }
}

