/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.gui;

import logisticspipes.interfaces.IGUIChannelInformationReceiver;
import logisticspipes.network.abstractpackets.GuiPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ChannelInformationPacket
extends GuiPacket {
    private ChannelInformation information;
    private boolean targeted;

    public ChannelInformationPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.information = input.readChannelInformation();
        this.targeted = input.readBoolean();
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeChannelInformation(this.information);
        output.writeBoolean(this.targeted);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        IGUIChannelInformationReceiver screen = this.getGui(IGUIChannelInformationReceiver.class);
        if (screen != null) {
            screen.handleChannelInformation(this.information, this.targeted);
        } else if (this.targeted) {
            throw new TargetNotFoundException("GuiDoesNotWantPacket", this);
        }
    }

    @Override
    public ModernPacket template() {
        return new ChannelInformationPacket(this.getId());
    }

    public ChannelInformation getInformation() {
        return this.information;
    }

    public ChannelInformationPacket setInformation(ChannelInformation information) {
        this.information = information;
        return this;
    }

    public boolean isTargeted() {
        return this.targeted;
    }

    public ChannelInformationPacket setTargeted(boolean targeted) {
        this.targeted = targeted;
        return this;
    }
}

