/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.gui.hud.HUDInvSysConnector;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.routing.IChannelManager;
import logisticspipes.interfaces.routing.IChannelRoutingConnection;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.pipe.InvSysConGuiProvider;
import logisticspipes.network.packets.gui.ChannelInformationPacket;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.orderer.OrdererManagerContent;
import logisticspipes.network.packets.pipe.InvSysConResistance;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.TransportInvConnection;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.transactor.ITransactor;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

public class PipeItemsInvSysConnector
extends CoreRoutedPipe
implements IChannelRoutingConnection,
IHeadUpDisplayRendererProvider,
IOrderManagerContentReceiver,
IGuiOpenControler {
    private boolean init = false;
    private HashMap<ItemIdentifier, List<ItemRoutingInformation>> itemsOnRoute = new HashMap();
    public int resistance;
    public Set<ItemIdentifierStack> oldList = new TreeSet<ItemIdentifierStack>();
    public final LinkedList<ItemIdentifierStack> displayList = new LinkedList();
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    public final PlayerCollectionList localGuiWatchers = new PlayerCollectionList();
    private HUDInvSysConnector HUD = new HUDInvSysConnector(this);
    private UUID idbuffer = UUID.randomUUID();
    private UUID connectedChannel;
    private static UUID testUUID = UUID.randomUUID();

    public PipeItemsInvSysConnector(Item item) {
        super(new TransportInvConnection(), item);
    }

    @Override
    public void enabledUpdateEntity() {
        List<CoreRoutedPipe> connectedPipes;
        super.enabledUpdateEntity();
        if (!this.init && this.hasConnectionUUID()) {
            if (!SimpleServiceLocator.connectionManager.addChannelConnection(this.getConnectionUUID(), this.getRouter())) {
                this.connectedChannel = null;
                this.sendChannelInformationToPlayers();
            }
            if ((connectedPipes = SimpleServiceLocator.connectionManager.getConnectedPipes(this.getRouter())) != null) {
                connectedPipes.forEach(c -> {
                    c.getRouter().update(true, (CoreRoutedPipe)c);
                    c.refreshRender(true);
                });
            }
            this.getRouter().update(true, this);
            this.refreshRender(true);
            this.init = true;
            this.idbuffer = this.getConnectionUUID();
        }
        if (this.init && !this.hasConnectionUUID()) {
            this.init = false;
            connectedPipes = SimpleServiceLocator.connectionManager.getConnectedPipes(this.getRouter());
            SimpleServiceLocator.connectionManager.removeChannelConnection(this.getRouter());
            if (connectedPipes != null) {
                connectedPipes.forEach(c -> {
                    c.getRouter().update(true, (CoreRoutedPipe)c);
                    c.refreshRender(true);
                });
            }
        }
        if (this.init && this.idbuffer != null && !this.idbuffer.equals(this.getConnectionUUID())) {
            this.init = false;
            connectedPipes = SimpleServiceLocator.connectionManager.getConnectedPipes(this.getRouter());
            SimpleServiceLocator.connectionManager.removeChannelConnection(this.getRouter());
            if (connectedPipes != null) {
                connectedPipes.forEach(c -> {
                    c.getRouter().update(true, (CoreRoutedPipe)c);
                    c.refreshRender(true);
                });
            }
        }
        if (this.itemsOnRoute.size() > 0) {
            this.checkConnectedInvs();
        }
    }

    private void checkConnectedInvs() {
        boolean shouldUpdate;
        if (!this.itemsOnRoute.isEmpty() && (shouldUpdate = new WorldCoordinatesWrapper(this.container).connectedTileEntities(IPipeInformationProvider.ConnectionPipeType.ITEM).anyMatch(neighbor -> neighbor.isItemHandler() && this.container.canPipeConnect((TileEntity)neighbor.getTileEntity(), neighbor.getDirection()) && this.checkOneConnectedInv(neighbor.getUtilForItemHandler(), neighbor.getDirection())))) {
            this.updateContentListener();
        }
    }

    private boolean checkOneConnectedInv(@Nonnull IInventoryUtil inv, EnumFacing dir) {
        boolean contentchanged = false;
        if (!this.itemsOnRoute.isEmpty()) {
            ArrayList<ItemIdentifier> items = new ArrayList<ItemIdentifier>(this.itemsOnRoute.keySet());
            items.retainAll(inv.getItems());
            Map<ItemIdentifier, Integer> amounts = null;
            if (!items.isEmpty()) {
                amounts = inv.getItemsAndCount();
            }
            block0: for (ItemIdentifier ident : items) {
                if (!amounts.containsKey(ident)) continue;
                int itemAmount = amounts.get(ident);
                List<ItemRoutingInformation> needs = this.itemsOnRoute.get(ident);
                Iterator<ItemRoutingInformation> iterator = needs.iterator();
                while (iterator.hasNext()) {
                    ItemRoutingInformation need = iterator.next();
                    if (need.getItem().getStackSize() > itemAmount) continue;
                    if (!this.useEnergy(6)) {
                        return contentchanged;
                    }
                    ItemStack toSend = inv.getMultipleItems(ident, need.getItem().getStackSize());
                    if (toSend.func_190926_b()) {
                        return contentchanged;
                    }
                    if (toSend.func_190916_E() != need.getItem().getStackSize()) {
                        if (inv instanceof ITransactor) {
                            ((ITransactor)((Object)inv)).add(toSend, dir.func_176734_d(), true);
                        } else {
                            this.container.func_145831_w().func_72838_d((Entity)ItemIdentifierStack.getFromStack(toSend).makeEntityItem(this.getWorld(), this.container.getX(), this.container.getY(), this.container.getZ()));
                        }
                        new UnsupportedOperationException("The extracted amount didn't match the requested one. (" + inv + ")").printStackTrace();
                        return contentchanged;
                    }
                    this.sendStack(need, dir);
                    iterator.remove();
                    contentchanged = true;
                    if (needs.isEmpty()) {
                        this.itemsOnRoute.remove(ident);
                    }
                    if ((amounts = inv.getItemsAndCount()).containsKey(ident)) {
                        itemAmount = amounts.get(ident);
                        continue;
                    }
                    itemAmount = 0;
                    continue block0;
                }
            }
        }
        return contentchanged;
    }

    public void sendStack(ItemRoutingInformation info, EnumFacing dir) {
        LPTravelingItem.LPTravelingItemServer itemToSend = SimpleServiceLocator.routedItemHelper.createNewTravelItem(info);
        super.queueRoutedItem(itemToSend, dir);
        this.spawnParticle(Particles.OrangeParticle, 4);
    }

    private UUID getConnectionUUID() {
        return this.connectedChannel;
    }

    private boolean hasConnectionUUID() {
        return this.connectedChannel != null;
    }

    public Set<ItemIdentifierStack> getExpectedItems() {
        TreeSet<ItemIdentifierStack> list = new TreeSet<ItemIdentifierStack>();
        for (Map.Entry<ItemIdentifier, List<ItemRoutingInformation>> entry : this.itemsOnRoute.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            ItemIdentifierStack currentStack = new ItemIdentifierStack(entry.getKey(), 0);
            for (ItemRoutingInformation e : entry.getValue()) {
                currentStack.setStackSize(currentStack.getStackSize() + e.getItem().getStackSize());
            }
            list.add(currentStack);
        }
        return list;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        NewGuiHandler.getGui(InvSysConGuiProvider.class).setTilePos(this.container).open(entityplayer);
    }

    @Override
    public void onAllowedRemoval() {
        this.removePipeFromChannel();
    }

    private void removePipeFromChannel() {
        if (!this.stillNeedReplace) {
            List<CoreRoutedPipe> connectedPipes = SimpleServiceLocator.connectionManager.getConnectedPipes(this.getRouter());
            SimpleServiceLocator.connectionManager.removeChannelConnection(this.getRouter());
            if (connectedPipes != null) {
                connectedPipes.forEach(c -> c.refreshRender(true));
            }
        }
    }

    @Override
    public void invalidate() {
        this.removePipeFromChannel();
        this.init = false;
        super.invalidate();
    }

    @Override
    public void onChunkUnload() {
        this.removePipeFromChannel();
        this.init = false;
        super.onChunkUnload();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("resistance", this.resistance);
        if (this.connectedChannel != null) {
            nbttagcompound.func_74778_a("connectedChannel", this.connectedChannel.toString());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.resistance = nbttagcompound.func_74762_e("resistance");
        this.connectedChannel = nbttagcompound.func_74764_b("connectedChannel") ? UUID.fromString(nbttagcompound.func_74779_i("connectedChannel")) : null;
    }

    private boolean hasRemoteConnection() {
        return this.hasConnectionUUID() && this.getWorld() != null && SimpleServiceLocator.connectionManager.hasChannelConnection(this.getRouter());
    }

    private boolean isInventoryConnected(@Nullable TileEntity tileEntityFilter) {
        return new WorldCoordinatesWrapper(this.container).allNeighborTileEntities().anyMatch(neighbor -> (tileEntityFilter == null || neighbor.getTileEntity() == tileEntityFilter) && neighbor.isItemHandler() && this.container.canPipeConnect((TileEntity)neighbor.getTileEntity(), neighbor.getDirection()));
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        if (!this.stillNeedReplace && this.hasRemoteConnection()) {
            if (this.isInventoryConnected(null)) {
                return Textures.LOGISTICSPIPE_INVSYSCON_CON_TEXTURE;
            }
            return Textures.LOGISTICSPIPE_INVSYSCON_MIS_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_INVSYSCON_DIS_TEXTURE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    @Override
    public int getConnectionResistance() {
        return this.resistance;
    }

    @Override
    public void addItem(ItemRoutingInformation info) {
        if (info.getItem() != null && info.getItem().getStackSize() > 0 && info.destinationint >= 0) {
            ItemIdentifier insertedType = info.getItem().getItem();
            List entry = this.itemsOnRoute.computeIfAbsent(insertedType, k -> new LinkedList());
            entry.add(info);
            this.updateContentListener();
        }
    }

    public void handleItemEnterInv(ItemRoutingInformation info, TileEntity tile) {
        if (info.getItem().getStackSize() == 0) {
            return;
        }
        if (this.isInventoryConnected(tile) && this.hasRemoteConnection()) {
            List<CoreRoutedPipe> connectedPipes = SimpleServiceLocator.connectionManager.getConnectedPipes(this.getRouter());
            Optional<CoreRoutedPipe> bestConnection = connectedPipes.stream().map(con -> new Triplet<CoreRoutedPipe, ExitRoute, ExitRoute>((CoreRoutedPipe)con, con.getRouter().getExitFor(info.destinationint, info._transportMode == IRoutedItem.TransportMode.Active, info.getItem().getItem()), con.getRouter().getExitFor(this.getRouterId(), info._transportMode == IRoutedItem.TransportMode.Active, info.getItem().getItem()))).filter(triplet -> triplet.getValue2() != null && triplet.getValue3() != null).filter(triplet -> ((ExitRoute)triplet.getValue2()).exitOrientation != ((ExitRoute)triplet.getValue3()).exitOrientation).min(Comparator.comparing(trip -> ((ExitRoute)trip.getValue2()).blockDistance)).map(Pair::getValue1);
            if (!bestConnection.isPresent()) {
                bestConnection = connectedPipes.stream().map(con -> new Pair<CoreRoutedPipe, ExitRoute>((CoreRoutedPipe)con, con.getRouter().getExitFor(info.destinationint, info._transportMode == IRoutedItem.TransportMode.Active, info.getItem().getItem()))).filter(triplet -> triplet.getValue2() != null).min(Comparator.comparing(trip -> ((ExitRoute)trip.getValue2()).blockDistance)).map(Pair::getValue1);
            }
            if (bestConnection.isPresent() && bestConnection.get() instanceof IChannelRoutingConnection) {
                IChannelRoutingConnection pipe = (IChannelRoutingConnection)((Object)bestConnection.get());
                pipe.addItem(info);
                this.spawnParticle(Particles.OrangeParticle, 4);
            }
        }
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    private void updateContentListener() {
        Set<ItemIdentifierStack> newList;
        if (!this.localModeWatchers.isEmpty() && !(newList = this.getExpectedItems()).equals(this.oldList)) {
            this.oldList = newList;
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(OrdererManagerContent.class).setIdentSet(newList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OrdererManagerContent.class).setIdentSet(this.getExpectedItems()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void setOrderManagerContent(Collection<ItemIdentifierStack> list) {
        this.displayList.clear();
        this.displayList.addAll(list);
    }

    public void setChannelFromClient(UUID fromString) {
        this.connectedChannel = fromString;
        this.sendChannelInformationToPlayers();
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.localGuiWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(InvSysConResistance.class).setInteger(this.resistance).setBlockPos(this.getPos()), player);
        IChannelManager manager = SimpleServiceLocator.channelManagerProvider.getChannelManager(this.getWorld());
        Optional<ChannelInformation> channel = manager.getChannels().stream().filter(chan -> chan.getChannelIdentifier().equals(this.getConnectionUUID())).findFirst();
        channel.ifPresent(chan -> MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ChannelInformationPacket.class).setInformation((ChannelInformation)chan).setTargeted(true), player));
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.localGuiWatchers.remove(player);
    }

    private void sendChannelInformationToPlayers() {
        IChannelManager manager = SimpleServiceLocator.channelManagerProvider.getChannelManager(this.getWorld());
        Optional<ChannelInformation> channel = manager.getChannels().stream().filter(chan -> chan.getChannelIdentifier().equals(this.getConnectionUUID())).findFirst();
        channel.ifPresent(chan -> MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ChannelInformationPacket.class).setInformation((ChannelInformation)chan).setTargeted(true), this.localGuiWatchers));
    }
}

