/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRequestAPI;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCQueued;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.request.RequestHandler;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;

@CCType(name="LogisticsPipes:Request")
public class PipeItemsRequestLogistics
extends CoreRoutedPipe
implements IRequestItems,
IRequestAPI {
    private final LinkedList<Map<ItemIdentifier, Integer>> _history = new LinkedList();

    public PipeItemsRequestLogistics(Item item) {
        super(item);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_REQUESTER_TEXTURE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public void openGui(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 31, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public boolean handleClick(EntityPlayer entityplayer, SecuritySettings settings) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (settings == null || settings.openRequest) {
                this.openGui(entityplayer);
            } else {
                entityplayer.func_145747_a((ITextComponent)new TextComponentString("Permission denied"));
            }
        }
        return true;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.getWorld().func_82737_E() % 1200L == 0L) {
            this._history.addLast(SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost()));
            if (this._history.size() > 20) {
                this._history.removeFirst();
            }
        }
    }

    public LinkedList<Map<ItemIdentifier, Integer>> getHistory() {
        return this._history;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public List<ItemStack> getProvidedItems() {
        if (this.stillNeedReplace()) {
            return new ArrayList<ItemStack>();
        }
        Map<ItemIdentifier, Integer> items = SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost());
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(items.size());
        for (Map.Entry<ItemIdentifier, Integer> item : items.entrySet()) {
            ItemStack is = item.getKey().unsafeMakeNormalStack(item.getValue());
            list.add(is);
        }
        return list;
    }

    @Override
    public List<ItemStack> getCraftedItems() {
        if (this.stillNeedReplace()) {
            return new ArrayList<ItemStack>();
        }
        LinkedList<ItemIdentifier> items = SimpleServiceLocator.logisticsManager.getCraftableItems(this.getRouter().getIRoutersByCost());
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(items.size());
        for (ItemIdentifier item : items) {
            ItemStack is = item.unsafeMakeNormalStack(1);
            list.add(is);
        }
        return list;
    }

    @Override
    public IRequestAPI.SimulationResult simulateRequest(ItemStack wanted) {
        final ArrayList used = new ArrayList();
        final ArrayList missing = new ArrayList();
        RequestTree.simulate(ItemIdentifier.get(wanted).makeStack(wanted.func_190916_E()), this, new RequestLog(){

            @Override
            public void handleMissingItems(List<IResource> items) {
                missing.addAll(items);
            }

            @Override
            public void handleSucessfullRequestOf(IResource item, LinkedLogisticsOrderList parts) {
            }

            @Override
            public void handleSucessfullRequestOfList(List<IResource> items, LinkedLogisticsOrderList parts) {
                used.addAll(items);
            }
        });
        ArrayList<ItemStack> usedList = new ArrayList<ItemStack>(used.size());
        ArrayList<ItemStack> missingList = new ArrayList<ItemStack>(missing.size());
        for (IResource e : used) {
            if (e instanceof ItemResource) {
                usedList.add(((ItemResource)e).getItem().unsafeMakeNormalStack(e.getRequestedAmount()));
                continue;
            }
            if (!(e instanceof DictResource)) continue;
            usedList.add(((DictResource)e).getItem().unsafeMakeNormalStack(e.getRequestedAmount()));
        }
        for (IResource e : missing) {
            if (e instanceof ItemResource) {
                missingList.add(((ItemResource)e).getItem().unsafeMakeNormalStack(e.getRequestedAmount()));
                continue;
            }
            if (!(e instanceof DictResource)) continue;
            missingList.add(((DictResource)e).getItem().unsafeMakeNormalStack(e.getRequestedAmount()));
        }
        IRequestAPI.SimulationResult r = new IRequestAPI.SimulationResult();
        r.used = usedList;
        r.missing = missingList;
        return r;
    }

    @Override
    public List<ItemStack> performRequest(ItemStack wanted) {
        final ArrayList missing = new ArrayList();
        RequestTree.request(ItemIdentifier.get(wanted).makeStack(wanted.func_190916_E()), this, new RequestLog(){

            @Override
            public void handleMissingItems(List<IResource> items) {
                missing.addAll(items);
            }

            @Override
            public void handleSucessfullRequestOf(IResource item, LinkedLogisticsOrderList parts) {
            }

            @Override
            public void handleSucessfullRequestOfList(List<IResource> items, LinkedLogisticsOrderList parts) {
            }
        }, null);
        ArrayList<ItemStack> missingList = new ArrayList<ItemStack>(missing.size());
        for (IResource e : missing) {
            if (e instanceof ItemResource) {
                missingList.add(((ItemResource)e).getItem().unsafeMakeNormalStack(e.getRequestedAmount()));
                continue;
            }
            if (!(e instanceof DictResource)) continue;
            missingList.add(((DictResource)e).getItem().unsafeMakeNormalStack(e.getRequestedAmount()));
        }
        return missingList;
    }

    @CCCommand(description="Requests the given ItemIdentifierStack")
    @CCQueued
    public Object[] makeRequest(ItemIdentifierStack stack) throws Exception {
        return this.makeRequest(stack.getItem(), Double.valueOf(stack.getStackSize()), false);
    }

    @CCCommand(description="Requests the given ItemIdentifierStack")
    @CCQueued
    public Object[] makeRequest(ItemIdentifierStack stack, Boolean forceCrafting) throws Exception {
        return this.makeRequest(stack.getItem(), Double.valueOf(stack.getStackSize()), forceCrafting);
    }

    @CCCommand(description="Requests the given ItemIdentifier with the given amount")
    @CCQueued
    public Object[] makeRequest(ItemIdentifier item, Double amount) throws Exception {
        return this.makeRequest(item, amount, false);
    }

    @CCCommand(description="Requests the given ItemIdentifier with the given amount")
    @CCQueued
    public Object[] makeRequest(ItemIdentifier item, Double amount, Boolean forceCrafting) throws Exception {
        if (forceCrafting == null) {
            forceCrafting = false;
        }
        if (item == null) {
            throw new Exception("Invalid ItemIdentifier");
        }
        return RequestHandler.computerRequest(item.makeStack((int)Math.floor(amount)), this, forceCrafting);
    }

    @CCCommand(description="Asks for all available ItemIdentifier inside the Logistics Network")
    @CCQueued
    public List<Pair<ItemIdentifier, Integer>> getAvailableItems() {
        Map<ItemIdentifier, Integer> items = SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost());
        LinkedList<Pair<ItemIdentifier, Integer>> list = new LinkedList<Pair<ItemIdentifier, Integer>>();
        for (Map.Entry<ItemIdentifier, Integer> item : items.entrySet()) {
            int amount = item.getValue();
            list.add(new Pair<ItemIdentifier, Integer>(item.getKey(), amount));
        }
        return list;
    }

    @CCCommand(description="Asks for all craftable ItemIdentifier inside the Logistics Network")
    @CCQueued
    public List<ItemIdentifier> getCraftableItems() {
        LinkedList<ItemIdentifier> items = SimpleServiceLocator.logisticsManager.getCraftableItems(this.getRouter().getIRoutersByCost());
        return items;
    }

    @CCCommand(description="Asks for the amount of an ItemIdentifier Id inside the Logistics Network")
    @CCQueued
    public int getItemAmount(ItemIdentifier item) throws Exception {
        Map<ItemIdentifier, Integer> items = SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost());
        if (item == null) {
            throw new Exception("Invalid ItemIdentifierID");
        }
        if (items.containsKey(item)) {
            return items.get(item);
        }
        return 0;
    }
}

