/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LPBlocks;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.proxy.MainProxy;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class LogisticsBlockGenericSubMultiBlock
extends BlockContainer {
    protected final Random rand = new Random();
    public static boolean redirectedToMainPipe = false;
    public static DoubleCoordinates currentCreatedMultiBlock;

    public LogisticsBlockGenericSubMultiBlock() {
        super(Material.field_151592_s);
        this.func_149647_a(LogisticsPipes.CREATIVE_TAB_LP);
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof LogisticsTileGenericSubMultiBlock) {
            List<LogisticsTileGenericPipe> mainPipeList = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe();
            return mainPipeList.stream().filter(Objects::nonNull).filter(LogisticsTileGenericPipe::isMultiBlock).map(mainPipe -> LPBlocks.pipe.getDrops(world, mainPipe.func_174877_v(), world.func_180495_p(mainPipe.func_174877_v()), fortune)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        if (currentCreatedMultiBlock == null && MainProxy.isServer((IBlockAccess)worldIn)) {
            new RuntimeException("Unknown MultiBlock controller").printStackTrace();
        }
        return new LogisticsTileGenericSubMultiBlock(currentCreatedMultiBlock);
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (redirectedToMainPipe) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof LogisticsTileGenericSubMultiBlock) {
            List<LogisticsTileGenericPipe> mainPipeList = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe();
            mainPipeList.stream().filter(Objects::nonNull).filter(LogisticsTileGenericPipe::isMultiBlock).forEach(mainPipe -> {
                redirectedToMainPipe = true;
                LPBlocks.pipe.func_180663_b(worldIn, mainPipe.getBlockPos(), worldIn.func_180495_p(mainPipe.getBlockPos()));
                redirectedToMainPipe = false;
                worldIn.func_175698_g(mainPipe.func_174877_v());
            });
        }
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (world.field_72995_K) {
            return;
        }
        BlockPos mainPipePos = LogisticsBlockGenericPipe.pipeSubMultiRemoved.get(new DoubleCoordinates(pos));
        if (mainPipePos != null) {
            LPBlocks.pipe.func_180653_a(world, mainPipePos, null, chance, fortune);
        }
    }

    public float func_176195_g(IBlockState state, World par1World, BlockPos pos) {
        return Configs.pipeDurability;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof LogisticsTileGenericSubMultiBlock) {
            List<LogisticsTileGenericPipe> mainPipeList = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe();
            mainPipeList.stream().filter(Objects::nonNull).filter(LogisticsTileGenericPipe::isMultiBlock).forEach(mainPipe -> LPBlocks.pipe.addCollisionBoxToList((LogisticsTileGenericPipe)mainPipe, entityBox, collidingBoxes, entityIn, isActualState));
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof LogisticsTileGenericSubMultiBlock) {
            List<LogisticsTileGenericPipe> mainPipeList = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe();
            return mainPipeList.stream().filter(Objects::nonNull).filter(LogisticsTileGenericPipe::isMultiBlock).map(mainPipe -> LPBlocks.pipe.func_180636_a(blockState, worldIn, mainPipe.func_174877_v(), start, end)).filter(Objects::nonNull).findFirst().map(it -> {
                RayTraceResult result = new RayTraceResult(it.field_72313_a, it.field_72307_f, it.field_178784_b, pos);
                result.subHit = it.subHit;
                result.field_72307_f = it.field_72307_f;
                result.hitInfo = it.hitInfo;
                result.field_72308_g = it.field_72308_g;
                return result;
            }).orElse(null);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB func_180640_a(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        Optional<AxisAlignedBB> result = Optional.empty();
        if (tile instanceof LogisticsTileGenericSubMultiBlock) {
            List<LogisticsTileGenericPipe> mainPipeList = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe();
            result = mainPipeList.stream().filter(Objects::nonNull).filter(LogisticsTileGenericPipe::isMultiBlock).filter(mainPipe -> Objects.nonNull(LPBlocks.pipe.doRayTrace(worldIn, mainPipe.func_174877_v(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g))).map(mainPipe -> LPBlocks.pipe.func_180640_a(state, worldIn, mainPipe.func_174877_v())).findFirst();
        }
        return result.orElse(super.func_180640_a(state, worldIn, pos).func_72321_a((double)-0.85f, (double)-0.85f, (double)-0.85f));
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof LogisticsTileGenericSubMultiBlock) {
            ((LogisticsTileGenericSubMultiBlock)tile).scheduleNeighborChange();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TileEntity tile = world.func_175625_s(pos);
        Optional<Boolean> result = Optional.empty();
        if (tile instanceof LogisticsTileGenericSubMultiBlock) {
            IBlockState state = tile.func_145838_q().getExtendedState(tile.func_145838_q().func_176223_P(), (IBlockAccess)world, pos);
            List<LogisticsTileGenericPipe> mainPipeList = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe();
            result = mainPipeList.stream().filter(Objects::nonNull).filter(LogisticsTileGenericPipe::isMultiBlock).filter(mainPipe -> Objects.nonNull(LPBlocks.pipe.doRayTrace(world, mainPipe.func_174877_v(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g))).map(mainPipe -> LPBlocks.pipe.addDestroyEffects(world, mainPipe.func_174877_v(), manager)).findFirst();
        }
        return result.orElse(super.addDestroyEffects(world, pos, manager));
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        List<LogisticsTileGenericPipe> mainPipeList;
        TileEntity tile = world.func_175625_s(pos);
        Optional<Object> result = Optional.empty();
        if (tile instanceof LogisticsTileGenericSubMultiBlock && !(result = (mainPipeList = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe()).stream().filter(Objects::nonNull).filter(LogisticsTileGenericPipe::isMultiBlock).filter(mainPipe -> Objects.nonNull(LPBlocks.pipe.doRayTrace(world, mainPipe.func_174877_v(), player))).map(mainPipe -> LPBlocks.pipe.getPickBlock(state, target, world, mainPipe.func_174877_v(), player)).findFirst()).isPresent()) {
            result = mainPipeList.stream().findFirst().map(mainPipe -> LPBlocks.pipe.getPickBlock(state, target, world, mainPipe.func_174877_v(), player));
        }
        return result.orElse(super.getPickBlock(state, target, world, pos, player));
    }

    @SideOnly(value=Side.CLIENT)
    private void addHitEffects(LogisticsTileGenericPipe mainPipe, IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        TextureAtlasSprite icon = mainPipe.pipe.getIconProvider().getIcon(mainPipe.pipe.getIconIndexForItem());
        EnumFacing sideHit = target.field_178784_b;
        float b = 0.1f;
        AxisAlignedBB boundingBox = state.func_185900_c((IBlockAccess)world, target.func_178782_a());
        double px = (double)target.func_178782_a().func_177958_n() + this.rand.nextDouble() * (boundingBox.field_72336_d - boundingBox.field_72340_a - (double)0.2f) + (double)0.1f + boundingBox.field_72340_a;
        double py = (double)target.func_178782_a().func_177956_o() + this.rand.nextDouble() * (boundingBox.field_72337_e - boundingBox.field_72338_b - (double)0.2f) + (double)0.1f + boundingBox.field_72338_b;
        double pz = (double)target.func_178782_a().func_177952_p() + this.rand.nextDouble() * (boundingBox.field_72334_f - boundingBox.field_72339_c - (double)0.2f) + (double)0.1f + boundingBox.field_72339_c;
        switch (sideHit) {
            case DOWN: {
                py = (double)target.func_178782_a().func_177956_o() + boundingBox.field_72338_b - (double)0.1f;
                break;
            }
            case UP: {
                py = (double)target.func_178782_a().func_177956_o() + boundingBox.field_72337_e + (double)0.1f;
                break;
            }
            case NORTH: {
                pz = (double)target.func_178782_a().func_177952_p() + boundingBox.field_72339_c - (double)0.1f;
                break;
            }
            case SOUTH: {
                pz = (double)target.func_178782_a().func_177952_p() + boundingBox.field_72334_f + (double)0.1f;
                break;
            }
            case WEST: {
                px = (double)target.func_178782_a().func_177958_n() + boundingBox.field_72340_a - (double)0.1f;
                break;
            }
            case EAST: {
                px = (double)target.func_178782_a().func_177958_n() + boundingBox.field_72336_d + (double)0.1f;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        TileEntity tile = world.func_175625_s(target.func_178782_a());
        if (tile instanceof LogisticsTileGenericSubMultiBlock) {
            List<LogisticsTileGenericPipe> mainPipeList = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe();
            Optional<LogisticsTileGenericPipe> result = mainPipeList.stream().filter(Objects::nonNull).filter(LogisticsTileGenericPipe::isMultiBlock).filter(mainPipe -> Objects.nonNull(LPBlocks.pipe.doRayTrace(world, mainPipe.func_174877_v(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g))).findFirst();
            result.ifPresent(mainPipe -> this.addHitEffects((LogisticsTileGenericPipe)mainPipe, state, world, target, manager));
            if (result.isPresent()) {
                return true;
            }
        }
        return super.addHitEffects(state, world, target, manager);
    }
}

