/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.tubes;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.interfaces.ITubeRenderOrientation;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.tube.SCurveTubeRenderer;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeMultiBlockTransportLogistics;
import logisticspipes.utils.IPositionRotateble;
import logisticspipes.utils.LPPositionSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.DoubleCoordinatesType;

public class HSTubeSCurve
extends CoreMultiBlockPipe {
    private CurveSOrientation orientation;
    private List<AxisAlignedBB> boxes = null;

    public HSTubeSCurve(Item item) {
        super(new PipeMultiBlockTransportLogistics(), item);
    }

    @Override
    public void writeData(LPDataOutput output) {
        if (this.orientation == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeEnum(this.orientation);
        }
    }

    @Override
    public void readData(LPDataInput input) {
        if (input.readBoolean()) {
            this.orientation = input.readEnum(CurveSOrientation.class);
        }
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        return 0;
    }

    @Override
    public int getTextureIndex() {
        return 0;
    }

    @Override
    public LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> getSubBlocks() {
        LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> list = new LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>>(DoubleCoordinatesType.class);
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 0.0, -1.0, CoreMultiBlockPipe.SubBlockTypeForShare.S_CURVE_B));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 0.0, -2.0, CoreMultiBlockPipe.SubBlockTypeForShare.S_CURVE_A));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(1.0, 0.0, -1.0, CoreMultiBlockPipe.SubBlockTypeForShare.S_CURVE_A));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(1.0, 0.0, -2.0, CoreMultiBlockPipe.SubBlockTypeForShare.S_CURVE_B));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(1.0, 0.0, -3.0, CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
        return list;
    }

    @Override
    public LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> getRotatedSubBlocks() {
        LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> set = this.getSubBlocks();
        this.orientation.rotatePositions(set);
        return set;
    }

    @Override
    public void addCollisionBoxesToList(List arraylist, AxisAlignedBB axisalignedbb) {
        if (this.boxes == null || this.boxes.isEmpty()) {
            this.boxes = new ArrayList<AxisAlignedBB>();
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            for (int i = -1; i < 54; ++i) {
                double xOne = x;
                double yOne = y;
                double zOne = z;
                double xTwo = x;
                double yTwo = y + 1.0;
                double zTwo = z;
                if (this.orientation.getRenderOrientation() == TurnSDirection.NORTH_INV || this.orientation.getRenderOrientation() == TurnSDirection.NORTH) {
                    zOne += 1.0;
                    zTwo += 1.0;
                    zOne -= (double)(4.0f * (float)(i - 4) / 50.0f);
                    zTwo -= (double)(4.0f * (float)(i + 4) / 50.0f);
                    xOne -= 1.0;
                    xTwo += 2.0;
                } else if (this.orientation.getRenderOrientation() == TurnSDirection.EAST_INV || this.orientation.getRenderOrientation() == TurnSDirection.EAST) {
                    xOne += 4.0;
                    xTwo += 4.0;
                    xOne -= (double)(4.0f * (float)(i - 4) / 50.0f);
                    xTwo -= (double)(4.0f * (float)(i + 4) / 50.0f);
                    zOne -= 1.0;
                    zTwo += 2.0;
                }
                AxisAlignedBB box2 = SCurveTubeRenderer.getObjectBoundsAt(new AxisAlignedBB(Math.min(xOne, xTwo), Math.min(yOne, yTwo), Math.min(zOne, zTwo), Math.max(xOne, xTwo), Math.max(yOne, yTwo), Math.max(zOne, zTwo)).func_72317_d(-x, -y, -z), this.orientation);
                if (box2 == null) continue;
                LPPositionSet lpBox = new LPPositionSet(DoubleCoordinates.class);
                lpBox.addFrom(box2);
                DoubleCoordinates center = lpBox.getCenter();
                box2 = new AxisAlignedBB(center.getXCoord() - 0.3, center.getYCoord() - 0.3, center.getZCoord() - 0.3, center.getXCoord() + 0.3, center.getYCoord() + 0.3, center.getZCoord() + 0.3);
                AxisAlignedBB cBox = this.getCompleteBox();
                double minX = Math.max(box2.field_72340_a, cBox.field_72340_a);
                double minY = Math.max(box2.field_72338_b, cBox.field_72338_b);
                double minZ = Math.max(box2.field_72339_c, cBox.field_72339_c);
                double maxX = Math.min(box2.field_72336_d, cBox.field_72336_d);
                double maxY = Math.min(box2.field_72337_e, cBox.field_72337_e);
                double maxZ = Math.min(box2.field_72334_f, cBox.field_72334_f);
                this.boxes.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ).func_72317_d(x, y, z));
            }
        }
        arraylist.addAll(this.boxes.stream().filter(box -> box != null && (axisalignedbb == null || axisalignedbb.func_72326_a(box))).collect(Collectors.toList()));
    }

    @Override
    public AxisAlignedBB getCompleteBox() {
        return SCurveTubeRenderer.tubeSCurve.get(this.orientation.getRenderOrientation()).bounds().toAABB();
    }

    @Override
    public ITubeOrientation getTubeOrientation(EntityPlayer player, int xPos, int zPos) {
        double x = (double)xPos + 0.5 - player.field_70165_t;
        double z = (double)zPos + 0.5 - player.field_70161_v;
        double w = Math.atan2(x, z);
        double halfPI = 1.5707963267948966;
        double halfhalfPI = halfPI / 2.0;
        if ((w -= halfhalfPI) < 0.0) {
            w += Math.PI * 2;
        }
        EnumFacing dir = null;
        EnumFacing dir1 = null;
        EnumFacing dir2 = null;
        double addition = 0.0;
        if (0.0 < w && w <= halfPI) {
            dir = EnumFacing.EAST;
            dir1 = EnumFacing.NORTH;
            dir2 = EnumFacing.SOUTH;
            addition = halfPI;
        } else if (halfPI < w && w <= 2.0 * halfPI) {
            dir = EnumFacing.NORTH;
            dir1 = EnumFacing.EAST;
            dir2 = EnumFacing.WEST;
        } else if (2.0 * halfPI < w && w <= 3.0 * halfPI) {
            dir = EnumFacing.WEST;
            dir1 = EnumFacing.NORTH;
            dir2 = EnumFacing.SOUTH;
            addition = halfPI;
        } else if (3.0 * halfPI < w && w <= 4.0 * halfPI) {
            dir = EnumFacing.SOUTH;
            dir1 = EnumFacing.EAST;
            dir2 = EnumFacing.WEST;
        }
        w = Math.atan2(player.func_70040_Z().field_72450_a, player.func_70040_Z().field_72449_c);
        w -= addition;
        if (w < 0.0) {
            w += Math.PI * 2;
        }
        EnumFacing dir3 = null;
        if (0.0 < w && w <= 2.0 * halfPI) {
            dir3 = dir1;
        } else if (2.0 * halfPI < w && w <= 4.0 * halfPI) {
            dir3 = dir2;
        }
        for (CurveSOrientation curve : CurveSOrientation.values()) {
            if (!curve.dir.equals((Object)dir) || !curve.looking.equals((Object)dir3)) continue;
            return curve;
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74778_a("orientation", this.orientation.name());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.orientation = CurveSOrientation.valueOf(data.func_74779_i("orientation"));
    }

    @Override
    public float getPipeLength() {
        return 4.0f;
    }

    @Override
    public EnumFacing getExitForInput(EnumFacing commingFrom) {
        if (this.orientation.dir.func_176734_d() == commingFrom) {
            return this.orientation.dir;
        }
        if (this.orientation.dir == commingFrom) {
            return this.orientation.dir.func_176734_d();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TileEntity getConnectedEndTile(EnumFacing output) {
        boolean useOwn;
        if (this.orientation.getOffset().getLength() != 0.0) {
            if (this.orientation.dir.func_176734_d() == output) {
                useOwn = false;
            } else {
                if (this.orientation.dir != output) return null;
                useOwn = true;
            }
        } else if (this.orientation.dir.func_176734_d() == output) {
            useOwn = true;
        } else {
            if (this.orientation.dir != output) return null;
            useOwn = false;
        }
        if (useOwn) {
            return this.container.getTile(output);
        }
        DoubleCoordinates pos = new DoubleCoordinates(1.0, 0.0, -3.0);
        LPPositionSet set = new LPPositionSet(DoubleCoordinates.class);
        set.add(pos);
        this.orientation.rotatePositions(set);
        TileEntity subTile = pos.add(this.getLPPosition()).getTileEntity((IBlockAccess)this.getWorld());
        if (!(subTile instanceof LogisticsTileGenericSubMultiBlock)) return null;
        return ((LogisticsTileGenericSubMultiBlock)subTile).getTile(output);
    }

    @Override
    public boolean actAsNormalPipe() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISpecialPipeRenderer getSpecialRenderer() {
        return SCurveTubeRenderer.instance;
    }

    @Override
    public IHighlightPlacementRenderer getHighlightRenderer() {
        return SCurveTubeRenderer.instance;
    }

    @Override
    public DoubleCoordinates getItemRenderPos(float fPos, LPTravelingItem travelItem) {
        if (this.orientation.getDir().func_176734_d() == travelItem.input == (this.orientation.getOffset().getLength() != 0.0)) {
            fPos = this.transport.getPipeLength() - fPos;
        }
        float x = 0.5f;
        float y = 0.5f;
        float z = 0.5f;
        if (this.orientation.getRenderOrientation() == TurnSDirection.NORTH) {
            z -= fPos;
            z += 0.5f;
            x -= 0.0f;
            double a = fPos / this.transport.getPipeLength() * 3.0f;
            double b = -0.030238483815369 * Math.pow(a, 5.0) + 0.225914176523007 * Math.pow(a, 4.0) - 0.502711673373567 * Math.pow(a, 3.0) + 0.233256545765967 * Math.pow(a, 2.0) - 0.074807924321475 * a + 9.9653425518E-5;
            x = (float)((double)x + b * (double)this.transport.getPipeLength() / 3.0);
        } else if (this.orientation.getRenderOrientation() == TurnSDirection.NORTH_INV) {
            z -= fPos;
            z += 0.5f;
            x -= 0.0f;
            double a = fPos / this.transport.getPipeLength() * 3.0f;
            double b = -0.030238483815369 * Math.pow(a, 5.0) + 0.225914176523007 * Math.pow(a, 4.0) - 0.502711673373567 * Math.pow(a, 3.0) + 0.233256545765967 * Math.pow(a, 2.0) - 0.074807924321475 * a + 9.9653425518E-5;
            x = (float)((double)x - b * (double)this.transport.getPipeLength() / 3.0);
        } else if (this.orientation.getRenderOrientation() == TurnSDirection.EAST) {
            x -= fPos;
            x += 3.5f;
            z -= 1.0f;
            double a = fPos / this.transport.getPipeLength() * 3.0f;
            double b = -0.030238483815369 * Math.pow(a, 5.0) + 0.225914176523007 * Math.pow(a, 4.0) - 0.502711673373567 * Math.pow(a, 3.0) + 0.233256545765967 * Math.pow(a, 2.0) - 0.074807924321475 * a + 9.9653425518E-5;
            z = (float)((double)z - b * (double)this.transport.getPipeLength() / 3.0);
        } else if (this.orientation.getRenderOrientation() == TurnSDirection.EAST_INV) {
            x -= fPos;
            x += 3.5f;
            z += 1.0f;
            double a = fPos / this.transport.getPipeLength() * 3.0f;
            double b = -0.030238483815369 * Math.pow(a, 5.0) + 0.225914176523007 * Math.pow(a, 4.0) - 0.502711673373567 * Math.pow(a, 3.0) + 0.233256545765967 * Math.pow(a, 2.0) - 0.074807924321475 * a + 9.9653425518E-5;
            z = (float)((double)z + b * (double)this.transport.getPipeLength() / 3.0);
        }
        return new DoubleCoordinates(x, y, z);
    }

    @Override
    public double getItemRenderPitch(float fPos, LPTravelingItem travelItem) {
        return 0.0;
    }

    @Override
    public double getItemRenderYaw(float fPos, LPTravelingItem travelItem) {
        if (this.orientation.getDir().func_176734_d() == travelItem.input == (this.orientation.getOffset().getLength() != 0.0)) {
            fPos = this.transport.getPipeLength() - fPos;
        }
        double b = 0.0;
        if ((double)fPos < 0.5) {
            double a = 0.5 / (double)this.transport.getPipeLength() * 3.0;
            b = -0.15119241907684 * Math.pow(a, 4.0) + 0.903656706092028 * Math.pow(a, 3.0) - 1.5081350201207 * Math.pow(a, 2.0) + 0.466513091531934 * a - 0.074807924321475;
            b = b * (double)this.transport.getPipeLength() * -13.0;
            b = b * (double)fPos / 0.5;
        } else if ((double)fPos < 3.5) {
            double a = fPos / this.transport.getPipeLength() * 3.0f;
            b = -0.15119241907684 * Math.pow(a, 4.0) + 0.903656706092028 * Math.pow(a, 3.0) - 1.5081350201207 * Math.pow(a, 2.0) + 0.466513091531934 * a - 0.074807924321475;
            b = b * (double)this.transport.getPipeLength() * -13.0;
        } else {
            double a = 3.5 / (double)this.transport.getPipeLength() * 3.0;
            b = -0.15119241907684 * Math.pow(a, 4.0) + 0.903656706092028 * Math.pow(a, 3.0) - 1.5081350201207 * Math.pow(a, 2.0) + 0.466513091531934 * a - 0.074807924321475;
            b = b * (double)this.transport.getPipeLength() * -13.0;
            b = b * (double)(this.transport.getPipeLength() - fPos) / ((double)this.transport.getPipeLength() - 3.5);
        }
        if (this.orientation.getRenderOrientation() == TurnSDirection.NORTH) {
            return b;
        }
        if (this.orientation.getRenderOrientation() == TurnSDirection.NORTH_INV) {
            return -b;
        }
        if (this.orientation.getRenderOrientation() == TurnSDirection.EAST) {
            return 90.0 + b;
        }
        if (this.orientation.getRenderOrientation() == TurnSDirection.EAST_INV) {
            return 90.0 - b;
        }
        return 0.0;
    }

    @Override
    public double getBoxRenderScale(float fPos, LPTravelingItem travelItem) {
        return 1.0;
    }

    @Override
    public boolean isHSTube() {
        return true;
    }

    public CurveSOrientation getOrientation() {
        return this.orientation;
    }

    public static enum TurnSDirection implements ITubeRenderOrientation
    {
        NORTH(EnumFacing.NORTH),
        EAST(EnumFacing.EAST),
        NORTH_INV(EnumFacing.SOUTH),
        EAST_INV(EnumFacing.WEST);

        private EnumFacing dir1;

        public void rotatePositions(IPositionRotateble set) {
            if (this == NORTH) {
                set.mirrorX();
            } else if (this == EAST) {
                set.mirrorX();
                set.rotateRight();
            } else if (this == EAST_INV) {
                set.rotateRight();
            }
        }

        private TurnSDirection(EnumFacing dir1) {
            this.dir1 = dir1;
        }

        public EnumFacing getDir1() {
            return this.dir1;
        }
    }

    public static enum CurveSOrientation implements ITubeOrientation
    {
        NORTH_EAST(TurnSDirection.NORTH_INV, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.NORTH, EnumFacing.EAST),
        NORTH_WEST(TurnSDirection.NORTH, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.NORTH, EnumFacing.WEST),
        EAST_SOUTH(TurnSDirection.EAST_INV, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.EAST, EnumFacing.SOUTH),
        EAST_NORTH(TurnSDirection.EAST, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.EAST, EnumFacing.NORTH),
        SOUTH_WEST(TurnSDirection.NORTH_INV, new DoubleCoordinates(-1.0, 0.0, 3.0), EnumFacing.SOUTH, EnumFacing.WEST),
        SOUTH_EAST(TurnSDirection.NORTH, new DoubleCoordinates(1.0, 0.0, 3.0), EnumFacing.SOUTH, EnumFacing.EAST),
        WEST_NORTH(TurnSDirection.EAST_INV, new DoubleCoordinates(-3.0, 0.0, -1.0), EnumFacing.WEST, EnumFacing.NORTH),
        WEST_SOUTH(TurnSDirection.EAST, new DoubleCoordinates(-3.0, 0.0, 1.0), EnumFacing.WEST, EnumFacing.SOUTH);

        TurnSDirection renderOrientation;
        DoubleCoordinates offset;
        EnumFacing dir;
        EnumFacing looking;

        @Override
        public void rotatePositions(IPositionRotateble set) {
            this.renderOrientation.rotatePositions(set);
        }

        @Override
        public void setOnPipe(CoreMultiBlockPipe pipe) {
            ((HSTubeSCurve)pipe).orientation = this;
        }

        private CurveSOrientation(TurnSDirection renderOrientation, DoubleCoordinates offset, EnumFacing dir, EnumFacing looking) {
            this.renderOrientation = renderOrientation;
            this.offset = offset;
            this.dir = dir;
            this.looking = looking;
        }

        @Override
        public TurnSDirection getRenderOrientation() {
            return this.renderOrientation;
        }

        @Override
        public DoubleCoordinates getOffset() {
            return this.offset;
        }

        public EnumFacing getDir() {
            return this.dir;
        }

        public EnumFacing getLooking() {
            return this.looking;
        }
    }
}

