/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.tubes;

import java.util.List;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.interfaces.ITubeRenderOrientation;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.tube.SpeedupTubeRenderer;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeMultiBlockTransportLogistics;
import logisticspipes.utils.IPositionRotateble;
import logisticspipes.utils.LPPositionSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.DoubleCoordinatesType;

public class HSTubeSpeedup
extends CoreMultiBlockPipe {
    private SpeedupDirection orientation;

    public HSTubeSpeedup(Item item) {
        super(new PipeMultiBlockTransportLogistics(){

            @Override
            public boolean canPipeConnect(TileEntity tile, EnumFacing side) {
                if (side.func_176734_d() == ((HSTubeSpeedup)((HSTubeSpeedup)this.getMultiPipe())).orientation.dir1) {
                    return super.canPipeConnect_internal(tile, side);
                }
                return false;
            }

            @Override
            protected void handleTileReachedServer(LPTravelingItem.LPTravelingItemServer arrivingItem, TileEntity tile, EnumFacing dir) {
                if (dir.func_176734_d() == ((HSTubeSpeedup)((HSTubeSpeedup)this.getMultiPipe())).orientation.dir1) {
                    arrivingItem.setSpeed(0.19999999f);
                    this.handleTileReachedServer_internal(arrivingItem, tile, dir);
                } else {
                    super.handleTileReachedServer(arrivingItem, tile, dir);
                }
            }

            @Override
            protected void handleTileReachedClient(LPTravelingItem.LPTravelingItemClient arrivingItem, TileEntity tile, EnumFacing dir) {
                if (dir.func_176734_d() == ((HSTubeSpeedup)((HSTubeSpeedup)this.getMultiPipe())).orientation.dir1) {
                    if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
                        arrivingItem.setSpeed(0.19999999f);
                        this.passToNextPipe(arrivingItem, tile);
                    }
                } else {
                    super.handleTileReachedClient(arrivingItem, tile, dir);
                }
            }
        }, item);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeEnum(this.orientation);
    }

    @Override
    public void readData(LPDataInput input) {
        this.orientation = input.readEnum(SpeedupDirection.class);
    }

    @Override
    public LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> getSubBlocks() {
        LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> set = new LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>>(DoubleCoordinatesType.class);
        set.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 0.0, -1.0, CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
        set.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 0.0, -2.0, CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
        set.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 0.0, -3.0, CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
        return set;
    }

    @Override
    public LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> getRotatedSubBlocks() {
        LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> set = this.getSubBlocks();
        this.orientation.rotatePositions(set);
        return set;
    }

    @Override
    public void addCollisionBoxesToList(List arraylist, AxisAlignedBB axisalignedbb) {
        DoubleCoordinates pos = this.getLPPosition();
        DoubleCoordinates posMin = new DoubleCoordinates(0.1875, 0.1875, 0.1875);
        DoubleCoordinates posMax = new DoubleCoordinates(0.8125, 0.8125, -3.0);
        this.orientation.rotatePositions(posMin);
        this.orientation.rotatePositions(posMax);
        if (this.orientation == SpeedupDirection.EAST) {
            pos.add(new DoubleCoordinates(1.0, 0.0, 0.0));
        } else if (this.orientation == SpeedupDirection.SOUTH) {
            pos.add(new DoubleCoordinates(1.0, 0.0, 1.0));
        } else if (this.orientation == SpeedupDirection.WEST) {
            pos.add(new DoubleCoordinates(0.0, 0.0, 1.0));
        }
        posMin.add(pos);
        posMax.add(pos);
        LPPositionSet set = new LPPositionSet(DoubleCoordinates.class);
        set.add(posMin);
        set.add(posMax);
        AxisAlignedBB box = set.toABB();
        if (box != null && (axisalignedbb == null || axisalignedbb.func_72326_a(box))) {
            arraylist.add(box);
        }
    }

    @Override
    public AxisAlignedBB getCompleteBox() {
        return SpeedupTubeRenderer.tubeSpeedup.get(this.orientation).bounds().toAABB();
    }

    @Override
    public ITubeOrientation getTubeOrientation(EntityPlayer player, int xPos, int zPos) {
        double x = (double)xPos + 0.5 - player.field_70165_t;
        double z = (double)zPos + 0.5 - player.field_70161_v;
        double w = Math.atan2(x, z);
        double halfPI = 1.5707963267948966;
        double halfhalfPI = halfPI / 2.0;
        if ((w -= halfhalfPI) < 0.0) {
            w += Math.PI * 2;
        }
        EnumFacing dir = null;
        if (0.0 < w && w <= halfPI) {
            dir = EnumFacing.WEST;
        } else if (halfPI < w && w <= 2.0 * halfPI) {
            dir = EnumFacing.SOUTH;
        } else if (2.0 * halfPI < w && w <= 3.0 * halfPI) {
            dir = EnumFacing.EAST;
        } else if (3.0 * halfPI < w && w <= 4.0 * halfPI) {
            dir = EnumFacing.NORTH;
        }
        for (SpeedupDirection ori : SpeedupDirection.values()) {
            if (!ori.dir1.func_176734_d().equals((Object)dir)) continue;
            return ori;
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74778_a("orientation", this.orientation.name());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.orientation = SpeedupDirection.valueOf(data.func_74779_i("orientation"));
    }

    @Override
    public float getPipeLength() {
        return 4.0f;
    }

    @Override
    public EnumFacing getExitForInput(EnumFacing commingFrom) {
        return commingFrom.func_176734_d();
    }

    @Override
    public TileEntity getConnectedEndTile(EnumFacing output) {
        if (this.orientation.dir1 == output) {
            DoubleCoordinates pos = new DoubleCoordinates(0.0, 0.0, -3.0);
            LPPositionSet set = new LPPositionSet(DoubleCoordinates.class);
            set.add(pos);
            this.orientation.rotatePositions(set);
            TileEntity subTile = pos.add(this.getLPPosition()).getTileEntity((IBlockAccess)this.getWorld());
            if (subTile instanceof LogisticsTileGenericSubMultiBlock) {
                return ((LogisticsTileGenericSubMultiBlock)subTile).getTile(output);
            }
        } else if (this.orientation.dir1.func_176734_d() == output) {
            return this.container.getTile(output);
        }
        return null;
    }

    @Override
    public boolean actAsNormalPipe() {
        return true;
    }

    @Override
    public ISpecialPipeRenderer getSpecialRenderer() {
        return SpeedupTubeRenderer.instance;
    }

    @Override
    public IHighlightPlacementRenderer getHighlightRenderer() {
        return SpeedupTubeRenderer.instance;
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        return 0;
    }

    @Override
    public int getTextureIndex() {
        return 0;
    }

    @Override
    public boolean hasSpecialPipeEndAt(EnumFacing dir) {
        return dir == this.orientation.dir1;
    }

    @Override
    public DoubleCoordinates getItemRenderPos(float fPos, LPTravelingItem travelItem) {
        DoubleCoordinates pos = new DoubleCoordinates(0.5, 0.5, 0.5);
        float pPos = fPos;
        if (travelItem.input.func_176734_d() == this.orientation.dir1) {
            CoordinateUtils.add(pos, this.orientation.dir1, 3.0);
            pPos = this.getPipeLength() - fPos;
        }
        if ((double)pPos < 0.5) {
            if (travelItem.input == null) {
                return null;
            }
            if (!this.container.renderState.pipeConnectionMatrix.isConnected(travelItem.input.func_176734_d())) {
                return null;
            }
            CoordinateUtils.add(pos, travelItem.input.func_176734_d(), 0.5 - (double)fPos);
        } else {
            if (travelItem.output == null) {
                return null;
            }
            CoordinateUtils.add(pos, travelItem.output, (double)fPos - 0.5);
        }
        return pos;
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, EnumFacing side) {
        if (tile instanceof LogisticsTileGenericSubMultiBlock && this.getOrientation().getDir1() != side) {
            return false;
        }
        return super.canPipeConnect(tile, side);
    }

    @Override
    public boolean isHSTube() {
        return true;
    }

    public SpeedupDirection getOrientation() {
        return this.orientation;
    }

    public static enum SpeedupDirection implements ITubeRenderOrientation,
    ITubeOrientation
    {
        NORTH(EnumFacing.NORTH),
        SOUTH(EnumFacing.SOUTH),
        EAST(EnumFacing.EAST),
        WEST(EnumFacing.WEST);

        EnumFacing dir1;

        @Override
        public void rotatePositions(IPositionRotateble set) {
            if (this == SOUTH) {
                set.rotateLeft();
                set.rotateLeft();
            } else if (this == EAST) {
                set.rotateRight();
            } else if (this == WEST) {
                set.rotateLeft();
            }
        }

        @Override
        public ITubeRenderOrientation getRenderOrientation() {
            return this;
        }

        @Override
        public DoubleCoordinates getOffset() {
            return new DoubleCoordinates(0.0, 0.0, 0.0);
        }

        @Override
        public void setOnPipe(CoreMultiBlockPipe pipe) {
            ((HSTubeSpeedup)pipe).orientation = this;
        }

        private SpeedupDirection(EnumFacing dir1) {
            this.dir1 = dir1;
        }

        public EnumFacing getDir1() {
            return this.dir1;
        }
    }
}

