/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.side;

import java.io.File;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.items.ItemLogisticsPipe;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.UpdateName;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.IProxy;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.server.FMLServerHandler;

public class ServerProxy
implements IProxy {
    private Configuration langDatabase = new Configuration(new File("config/LogisticsPipes-LangDatabase.cfg"));
    private long saveThreadTime = 0L;

    @Override
    public String getSide() {
        return "Server";
    }

    @Override
    public World getWorld() {
        return null;
    }

    @Override
    public void registerTileEntities() {
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return null;
    }

    @Override
    public void registerParticles() {
    }

    private String getNameForCategory(String category, ItemIdentifier item) {
        String name = this.langDatabase.get(category, "name", "").getString();
        if (name.equals("")) {
            this.saveLangDatabase();
            if (item.isDamageable()) {
                return item.getFriendlyName();
            }
            return "LP|UNDEFINED";
        }
        return name;
    }

    private void setNameForCategory(String category, ItemIdentifier item, String newName) {
        this.langDatabase.get(category, "name", newName).set(newName);
        this.saveLangDatabase();
    }

    private void saveLangDatabase() {
        this.saveThreadTime = System.currentTimeMillis() + 30000L;
    }

    @Override
    public String getName(ItemIdentifier item) {
        String category = "";
        category = item.isDamageable() ? "itemNames." + Integer.toString(Item.func_150891_b((Item)item.item)) : (item.itemDamage == 0 ? "itemNames." + Integer.toString(Item.func_150891_b((Item)item.item)) : "itemNames." + Integer.toString(Item.func_150891_b((Item)item.item)) + "." + Integer.toString(item.itemDamage));
        String name = this.getNameForCategory(category, item);
        if (name.equals("LP|UNDEFINED")) {
            if (item.itemDamage == 0) {
                return item.getFriendlyName();
            }
            category = "itemNames." + Integer.toString(Item.func_150891_b((Item)item.item));
            name = this.getNameForCategory(category, item);
            if (name.equals("LP|UNDEFINED")) {
                return item.getFriendlyName();
            }
        }
        return name;
    }

    @Override
    public void updateNames(ItemIdentifier item, String name) {
        String category = "";
        category = item.isDamageable() ? "itemNames." + Integer.toString(Item.func_150891_b((Item)item.item)) : (item.itemDamage == 0 ? "itemNames." + Integer.toString(Item.func_150891_b((Item)item.item)) : "itemNames." + Integer.toString(Item.func_150891_b((Item)item.item)) + "." + Integer.toString(item.itemDamage));
        this.setNameForCategory(category, item, name);
    }

    @Override
    public void tick() {
        if (this.saveThreadTime != 0L && this.saveThreadTime < System.currentTimeMillis()) {
            this.saveThreadTime = 0L;
            this.langDatabase.save();
            LogisticsPipes.log.info("LangDatabase saved");
        }
    }

    @Override
    public void sendNameUpdateRequest(EntityPlayer player) {
        for (String category : this.langDatabase.getCategoryNames()) {
            String name;
            if (!category.startsWith("itemNames.") || !(name = this.langDatabase.get(category, "name", "").getString()).equals("")) continue;
            String itemPart = category.substring(10);
            String metaPart = "0";
            if (itemPart.contains(".")) {
                String[] itemPartSplit = itemPart.split("\\.");
                itemPart = itemPartSplit[0];
                metaPart = itemPartSplit[1];
            }
            int id = Integer.valueOf(itemPart);
            int meta = Integer.valueOf(metaPart);
            SimpleServiceLocator.serverBufferHandler.addPacketToCompressor(PacketHandler.getPacket(UpdateName.class).setIdent(ItemIdentifier.get(Item.func_150899_d((int)id), meta, null)).setName("-"), player);
        }
    }

    @Override
    public LogisticsTileGenericPipe getPipeInDimensionAt(int dimension, int x, int y, int z, EntityPlayer player) {
        return ServerProxy.getPipe((World)DimensionManager.getWorld((int)dimension), x, y, z);
    }

    protected static LogisticsTileGenericPipe getPipe(World world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        if (world.func_175623_d(new BlockPos(x, y, z))) {
            return null;
        }
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (!(tile instanceof LogisticsTileGenericPipe)) {
            return null;
        }
        return (LogisticsTileGenericPipe)tile;
    }

    @Override
    public void addLogisticsPipesOverride(Object par1IIconRegister, int index, String override1, String override2, boolean flag) {
    }

    @Override
    public void sendBroadCast(String message) {
        List list;
        MinecraftServer server = FMLServerHandler.instance().getServer();
        if (server != null && server.func_184103_al() != null && (list = server.func_184103_al().func_181057_v()) != null && !list.isEmpty()) {
            list.forEach(obj -> obj.func_145747_a((ITextComponent)new TextComponentString("[LP] Server: " + message)));
        }
    }

    @Override
    public void tickServer() {
        MainProxy.addTick();
    }

    @Override
    public void tickClient() {
    }

    @Override
    public EntityPlayer getEntityPlayerFromNetHandler(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)handler).field_147369_b;
        }
        return null;
    }

    @Override
    public void setIconProviderFromPipe(ItemLogisticsPipe item, CoreUnroutedPipe dummyPipe) {
    }

    @Override
    public LogisticsModule getModuleFromGui() {
        return null;
    }

    @Override
    public boolean checkSinglePlayerOwner(String commandSenderName) {
        return false;
    }

    @Override
    public void openFluidSelectGui(int slotId) {
    }

    @Override
    public void openGuideBookGui(EnumHand hand) {
    }

    @Override
    public void registerTextures() {
    }

    @Override
    public void initModelLoader() {
    }

    @Override
    public int getRenderIndex() {
        return 0;
    }
}

