/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.recipes;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import logisticspipes.items.RemoteOrderer;
import logisticspipes.recipes.IRecipeProvider;
import logisticspipes.recipes.ShapelessResetRecipe;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeManager {
    public static final List<IRecipeProvider> recipeProvider = new ArrayList<IRecipeProvider>();
    public static final LocalCraftingManager craftingManager = new LocalCraftingManager();

    public static void loadRecipes() {
        recipeProvider.forEach(IRecipeProvider::loadRecipes);
    }

    private static ResourceLocation getFreeRecipeResourceLocation(ItemStack stack) {
        return RecipeManager.getFreeRecipeResourceLocation(stack.func_77973_b());
    }

    private static ResourceLocation getFreeRecipeResourceLocation(Item item) {
        ResourceLocation baseLoc;
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation("logisticspipes", item.getRegistryName().func_110623_a());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation("logisticspipes", baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    public static class LocalCraftingManager {
        public void addRecipe(ItemStack stack, Object ... objects) {
            ArrayList result = new ArrayList();
            boolean[] addRecipe = new boolean[]{true};
            Arrays.stream(objects).forEach(o -> {
                if (!addRecipe[0]) {
                    return;
                }
                if (o instanceof RecipeLayout) {
                    result.add(((RecipeLayout)o).getLine1());
                    result.add(((RecipeLayout)o).getLine2());
                    result.add(((RecipeLayout)o).getLine3());
                } else if (o instanceof RecipeLayoutSmall) {
                    result.add(((RecipeLayoutSmall)o).getLine1());
                    result.add(((RecipeLayoutSmall)o).getLine2());
                } else if (o instanceof RecipeLayoutSmaller) {
                    result.add(((RecipeLayoutSmaller)o).getLine1());
                } else if (o instanceof RecipeIndex) {
                    result.add(Character.valueOf(((RecipeIndex)o).getIndex()));
                    result.add(((RecipeIndex)o).getValue());
                    if (((RecipeIndex)o).getValue() == null) {
                        addRecipe[0] = false;
                    }
                } else {
                    result.add(o);
                }
            });
            if (!addRecipe[0]) {
                return;
            }
            GameData.register_impl((IForgeRegistryEntry)new ShapedOreRecipe(new ResourceLocation("logisticspipes", "group.mainRecipeGroup"), stack, result.toArray()).setRegistryName(RecipeManager.getFreeRecipeResourceLocation(stack)));
        }

        private void dumpRecipe(ItemStack result, Object layout, RecipeIndex ... indices) {
            JsonObject obj = new JsonObject();
            JsonArray pattern = new JsonArray();
            JsonObject keys = new JsonObject();
            obj.addProperty("type", "minecraft:crafting_shaped");
            if (layout instanceof RecipeLayout) {
                pattern.add(((RecipeLayout)layout).getLine1());
                pattern.add(((RecipeLayout)layout).getLine2());
                pattern.add(((RecipeLayout)layout).getLine3());
            } else if (layout instanceof RecipeLayoutSmall) {
                pattern.add(((RecipeLayoutSmall)layout).getLine1());
                pattern.add(((RecipeLayoutSmall)layout).getLine2());
            } else if (layout instanceof RecipeLayoutSmaller) {
                pattern.add(((RecipeLayoutSmaller)layout).getLine1());
            }
            for (RecipeIndex index : indices) {
                JsonObject key = new JsonObject();
                if (index.getValue() instanceof String) {
                    key.addProperty("type", "forge:ore_dict");
                    key.addProperty("ore", (String)index.getValue());
                } else if (index.getValue() instanceof ItemStack) {
                    ItemStack stack = (ItemStack)index.getValue();
                    key.addProperty("item", stack.func_77973_b().getRegistryName().toString());
                    if (stack.func_77981_g()) {
                        key.addProperty("data", (Number)stack.func_77952_i());
                    }
                } else if (index.getValue() instanceof Item) {
                    key.addProperty("item", ((Item)index.getValue()).getRegistryName().toString());
                } else if (index.getValue() instanceof Block) {
                    key.addProperty("item", Item.func_150898_a((Block)((Block)index.getValue())).getRegistryName().toString());
                } else {
                    System.out.printf("unhandled ingredient type, skipping export (%s)\n", index.getValue());
                    return;
                }
                keys.add(index.getIndex() + "", (JsonElement)key);
            }
            JsonObject r = new JsonObject();
            r.addProperty("item", result.func_77973_b().getRegistryName().toString());
            if (result.func_77952_i() > 0) {
                r.addProperty("data", (Number)result.func_77952_i());
            }
            if (result.func_190916_E() > 1) {
                r.addProperty("count", (Number)result.func_190916_E());
            }
            obj.add("result", (JsonElement)r);
            obj.add("key", (JsonElement)keys);
            obj.add("pattern", (JsonElement)pattern);
            String format = result.func_77981_g() ? String.format("generated_recipes/%s.%d.json", result.func_77973_b().getRegistryName().func_110623_a(), result.func_77952_i()) : String.format("generated_recipes/%s.json", result.func_77973_b().getRegistryName().func_110623_a());
            File out = new File(format);
            out.getParentFile().mkdirs();
            String text = new Gson().toJson((JsonElement)obj);
            try {
                Files.write(out.toPath(), text.getBytes("UTF-8"), StandardOpenOption.CREATE_NEW);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void addOrdererRecipe(ItemStack stack, String dye, ItemStack orderer) {
            GameData.register_impl((IForgeRegistryEntry)new ShapelessOrdererRecipe(RecipeManager.getFreeRecipeResourceLocation(stack), stack, dye, orderer));
        }

        public void addShapelessRecipe(ItemStack stack, Object ... objects) {
            GameData.register_impl((IForgeRegistryEntry)new ShapelessOreRecipe(new ResourceLocation("logisticspipes", "group.mainRecipeGroup"), stack, objects).setRegistryName(RecipeManager.getFreeRecipeResourceLocation(stack)));
        }

        public void addShapelessResetRecipe(Item item, int meta) {
            ShapelessResetRecipe value = new ShapelessResetRecipe(item, meta);
            value.setRegistryName(RecipeManager.getFreeRecipeResourceLocation(item));
            GameData.register_impl((IForgeRegistryEntry)value);
        }

        public class ShapelessOrdererRecipe
        extends ShapelessOreRecipe {
            public ShapelessOrdererRecipe(ResourceLocation registryName, ItemStack result, Object ... recipe) {
                super(new ResourceLocation("logisticspipes", "group.mainRecipeGroup"), result, recipe);
                this.setRegistryName(registryName);
            }

            public ItemStack func_77572_b(InventoryCrafting var1) {
                ItemStack result = super.func_77572_b(var1);
                for (int i = 0; i < var1.func_70297_j_(); ++i) {
                    ItemStack stack = var1.func_70301_a(i);
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof RemoteOrderer)) continue;
                    result.func_77982_d(stack.func_77978_p());
                    break;
                }
                return result;
            }
        }
    }

    public static class RecipeLayoutSmaller {
        private String line1;

        @ConstructorProperties(value={"line1"})
        public RecipeLayoutSmaller(String line1) {
            this.line1 = line1;
        }

        public String getLine1() {
            return this.line1;
        }
    }

    public static class RecipeLayoutSmall {
        private String line1;
        private String line2;

        @ConstructorProperties(value={"line1", "line2"})
        public RecipeLayoutSmall(String line1, String line2) {
            this.line1 = line1;
            this.line2 = line2;
        }

        public String getLine1() {
            return this.line1;
        }

        public String getLine2() {
            return this.line2;
        }
    }

    public static class RecipeLayout {
        private String line1;
        private String line2;
        private String line3;

        @ConstructorProperties(value={"line1", "line2", "line3"})
        public RecipeLayout(String line1, String line2, String line3) {
            this.line1 = line1;
            this.line2 = line2;
            this.line3 = line3;
        }

        public String getLine1() {
            return this.line1;
        }

        public String getLine2() {
            return this.line2;
        }

        public String getLine3() {
            return this.line3;
        }
    }

    public static class RecipeIndex {
        private char index;
        private Object value;

        @ConstructorProperties(value={"index", "value"})
        public RecipeIndex(char index, Object value) {
            this.index = index;
            this.value = value;
        }

        public char getIndex() {
            return this.index;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

