/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import logisticspipes.utils.FluidIdentifier;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FluidContainerRenderer
implements IModel {
    private static final ResourceLocation STENCIL = new ResourceLocation("logisticspipes:items/liquids/stencil");
    private static final ResourceLocation EMPTY = new ResourceLocation("logisticspipes:items/liquids/empty");

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)EMPTY, (Object)STENCIL);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        ImmutableList.Builder builder = ImmutableList.builder();
        IBakedModel model = new ItemLayerModel(ImmutableList.of((Object)EMPTY)).bake(state, format, bakedTextureGetter);
        builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        TextureAtlasSprite particleSprite = model.func_177554_e();
        return new BakedItemModel(builder.build(), particleSprite, Maps.immutableEnumMap((Map)transformMap), (ItemOverrideList)new FluidContainerItemOverrideList(state, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transformMap, bakedTextureGetter));
    }

    private static class FluidContainerItemOverrideList
    extends ItemOverrideList {
        private static final float NORTH_Z = 0.468875f;
        private static final float SOUTH_Z = 0.531125f;
        private Map<FluidIdentifier, IBakedModel> cache = new HashMap<FluidIdentifier, IBakedModel>();
        private IModelState state;
        private VertexFormat format;
        private ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformMap;
        private Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;

        public FluidContainerItemOverrideList(IModelState state, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformMap, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            super((List)ImmutableList.of());
            this.state = state;
            this.format = format;
            this.transformMap = transformMap;
            this.bakedTextureGetter = bakedTextureGetter;
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
            FluidIdentifier fluidIdent = FluidIdentifier.get(stack);
            if (fluidIdent != null) {
                if (this.cache.containsKey(fluidIdent)) {
                    return this.cache.get(fluidIdent);
                }
                Fluid fluid = fluidIdent.getFluid();
                ResourceLocation fluidSprite = fluid.getStill(fluidIdent.makeFluidStack(1000));
                TRSRTransformation transform = new SimpleModelState(this.transformMap).apply(Optional.empty()).orElse(TRSRTransformation.identity());
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)this.format, (TRSRTransformation)transform, (TextureAtlasSprite)this.bakedTextureGetter.apply(STENCIL), (TextureAtlasSprite)this.bakedTextureGetter.apply(fluidSprite), (float)0.468875f, (EnumFacing)EnumFacing.NORTH, (int)fluid.getColor()));
                builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)this.format, (TRSRTransformation)transform, (TextureAtlasSprite)this.bakedTextureGetter.apply(STENCIL), (TextureAtlasSprite)this.bakedTextureGetter.apply(fluidSprite), (float)0.531125f, (EnumFacing)EnumFacing.SOUTH, (int)fluid.getColor()));
                builder.addAll((Iterable)originalModel.func_188616_a(null, null, 0L));
                BakedItemModel override = new BakedItemModel(builder.build(), this.bakedTextureGetter.apply(fluidSprite), Maps.immutableEnumMap(this.transformMap), ItemOverrideList.field_188022_a);
                this.cache.put(fluidIdent, (IBakedModel)override);
                return override;
            }
            return originalModel;
        }
    }

    public static class FluidContainerRendererModelLoader
    implements ICustomModelLoader {
        public boolean accepts(@Nonnull ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("logisticspipes") && modelLocation.func_110623_a().equals("models/item/fluid_container");
        }

        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return new FluidContainerRenderer();
        }

        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }
    }
}

