/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.newpipe.LogisticsNewPipeItemBoxRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.item.ItemStackRenderer;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelSign;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import network.rs485.debug.PerformanceMeter;
import network.rs485.logisticspipes.config.ClientConfiguration;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import org.lwjgl.opengl.GL11;

public class LogisticsRenderPipe
extends TileEntitySpecialRenderer<LogisticsTileGenericPipe> {
    private static final int LIQUID_STAGES = 40;
    private static final int MAX_ITEMS_TO_RENDER = 10;
    private static final ResourceLocation SIGN = new ResourceLocation("textures/entity/sign.png");
    public static LogisticsNewRenderPipe secondRenderer = new LogisticsNewRenderPipe();
    public static LogisticsNewPipeItemBoxRenderer boxRenderer = new LogisticsNewPipeItemBoxRenderer();
    public static ClientConfiguration config = LogisticsPipes.getClientPlayerConfig();
    private static ItemStackRenderer itemRenderer = new ItemStackRenderer(0, 0, 0.0f, false, false);
    private ModelSign modelSign;
    private final PerformanceMeter renderItemStackOnSignPerfMeter = new PerformanceMeter("renderItemStackOnSign", 60, LPConstants.DEBUG);

    public LogisticsRenderPipe() {
        this.modelSign = new ModelSign();
        this.modelSign.field_78165_b.field_78806_j = false;
    }

    public void render(LogisticsTileGenericPipe tileentity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        boolean inHand = false;
        if (tileentity == null && x == 0.0 && y == 0.0 && z == 0.0) {
            inHand = true;
        } else if (tileentity.pipe == null) {
            return;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179128_n((int)5888);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        if (destroyStage < 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        if (!inHand && tileentity.pipe instanceof CoreRoutedPipe) {
            this.renderPipeSigns((CoreRoutedPipe)tileentity.pipe, x, y, z, partialTicks);
        }
        double distance = !inHand ? new DoubleCoordinates(tileentity).distanceTo(new DoubleCoordinates((Entity)Minecraft.func_71410_x().field_71439_g)) : 0.0;
        secondRenderer.renderTileEntityAt(tileentity, x, y, z, partialTicks, distance);
        if (!inHand && !tileentity.isOpaque()) {
            if (tileentity.pipe.transport instanceof PipeFluidTransportLogistics) {
                // empty if block
            }
            if (tileentity.pipe.transport != null) {
                this.renderSolids(tileentity.pipe, x, y, z, partialTicks);
            }
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        if (!inHand) {
            SimpleServiceLocator.mcmpProxy.renderTileEntitySpecialRenderer(tileentity, x, y, z, partialTicks, destroyStage, alpha);
        }
    }

    private void renderSolids(CoreUnroutedPipe pipe, double x, double y, double z, float partialTickTime) {
        GL11.glPushMatrix();
        float light = pipe.container.func_145831_w().func_175724_o(pipe.container.func_174877_v());
        int count = 0;
        for (LPTravelingItem item : pipe.transport.items) {
            DoubleCoordinates pos;
            CoreUnroutedPipe lPipe = pipe;
            double lX = x;
            double lY = y;
            double lZ = z;
            float lItemYaw = item.getYaw();
            if (count >= 10) break;
            if (item.getItemIdentifierStack() == null || !item.getContainer().func_174877_v().equals((Object)lPipe.container.func_174877_v()) || item.getPosition() > lPipe.transport.getPipeLength() || item.getPosition() < 0.0f) continue;
            float fPos = item.getPosition() + item.getSpeed() * partialTickTime;
            if (fPos > lPipe.transport.getPipeLength() && item.output != null) {
                CoreUnroutedPipe nPipe = lPipe.transport.getNextPipe(item.output);
                if (nPipe == null) continue;
                fPos -= lPipe.transport.getPipeLength();
                lX -= (double)(lPipe.getX() - nPipe.getX());
                lY -= (double)(lPipe.getY() - nPipe.getY());
                lZ -= (double)(lPipe.getZ() - nPipe.getZ());
                lItemYaw += lPipe.transport.getYawDiff(item);
                lPipe = nPipe;
                item = item.renderCopy();
                item.input = item.output;
                item.output = null;
            }
            if ((pos = lPipe.getItemRenderPos(fPos, item)) == null) continue;
            double boxScale = lPipe.getBoxRenderScale(fPos, item);
            double itemYaw = (lPipe.getItemRenderYaw(fPos, item) - lPipe.getItemRenderYaw(0.0f, item) + (double)lItemYaw) % 360.0;
            double itemPitch = lPipe.getItemRenderPitch(fPos, item);
            double itemYawForPitch = lPipe.getItemRenderYaw(fPos, item);
            ItemStack itemstack = item.getItemIdentifierStack().makeNormalStack();
            this.doRenderItem(itemstack, pipe.container.func_145831_w(), lX + pos.getXCoord(), lY + pos.getYCoord(), lZ + pos.getZCoord(), light, 0.75f, boxScale, itemYaw, itemPitch, itemYawForPitch, partialTickTime);
            ++count;
        }
        count = 0;
        double dist = 0.135;
        DoubleCoordinates pos = new DoubleCoordinates(0.5, 0.5, 0.5);
        CoordinateUtils.add(pos, EnumFacing.SOUTH, dist);
        CoordinateUtils.add(pos, EnumFacing.EAST, dist);
        CoordinateUtils.add(pos, EnumFacing.UP, dist);
        for (Pair pair : pipe.transport._itemBuffer) {
            if (pair == null || pair.getValue1() == null) continue;
            ItemStack itemstack = ((ItemIdentifierStack)pair.getValue1()).makeNormalStack();
            this.doRenderItem(itemstack, pipe.container.func_145831_w(), x + pos.getXCoord(), y + pos.getYCoord(), z + pos.getZCoord(), light, 0.25f, 0.0, 0.0, 0.0, 0.0, partialTickTime);
            if (++count >= 27) break;
            if (count % 9 == 0) {
                CoordinateUtils.add(pos, EnumFacing.SOUTH, dist * 2.0);
                CoordinateUtils.add(pos, EnumFacing.EAST, dist * 2.0);
                CoordinateUtils.add(pos, EnumFacing.DOWN, dist);
                continue;
            }
            if (count % 3 == 0) {
                CoordinateUtils.add(pos, EnumFacing.SOUTH, dist * 2.0);
                CoordinateUtils.add(pos, EnumFacing.WEST, dist);
                continue;
            }
            CoordinateUtils.add(pos, EnumFacing.NORTH, dist);
        }
        GL11.glPopMatrix();
    }

    public void doRenderItem(@Nonnull ItemStack itemstack, World world, double x, double y, double z, float light, float renderScale, double boxScale, double yaw, double pitch, double yawForPitch, float partialTickTime) {
        boxRenderer.doRenderItem(itemstack, light, x, y, z, boxScale, yaw, pitch, yawForPitch);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        GL11.glRotated((double)yawForPitch, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)pitch, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)(-yawForPitch), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslatef((float)0.0f, (float)-0.35f, (float)0.0f);
        itemRenderer.setItemstack(itemstack).setWorld(world).setPartialTickTime(partialTickTime);
        itemRenderer.renderInWorld();
        GL11.glPopMatrix();
    }

    private boolean needDistance(List<Pair<EnumFacing, IPipeSign>> list) {
        boolean result;
        ArrayList<Pair<EnumFacing, IPipeSign>> copy = new ArrayList<Pair<EnumFacing, IPipeSign>>(list);
        Iterator iter = copy.iterator();
        boolean north = false;
        boolean south = false;
        boolean east = false;
        boolean west = false;
        while (iter.hasNext()) {
            Pair pair = (Pair)iter.next();
            if (pair.getValue1() == EnumFacing.UP || pair.getValue1() == EnumFacing.DOWN || pair.getValue1() == null) {
                iter.remove();
            }
            if (pair.getValue1() == EnumFacing.NORTH) {
                north = true;
            }
            if (pair.getValue1() == EnumFacing.SOUTH) {
                south = true;
            }
            if (pair.getValue1() == EnumFacing.EAST) {
                east = true;
            }
            if (pair.getValue1() != EnumFacing.WEST) continue;
            west = true;
        }
        boolean bl = result = copy.size() > 1;
        if (copy.size() == 2) {
            if (north && south) {
                result = false;
            }
            if (east && west) {
                result = false;
            }
        }
        return result;
    }

    private void renderPipeSigns(CoreRoutedPipe pipe, double x, double y, double z, float partialTickTime) {
        if (!pipe.getPipeSigns().isEmpty()) {
            List<Pair<EnumFacing, IPipeSign>> list = pipe.getPipeSigns();
            for (Pair<EnumFacing, IPipeSign> pair : list) {
                if (pipe.container.renderState.pipeConnectionMatrix.isConnected(pair.getValue1())) continue;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                switch (pair.getValue1()) {
                    case UP: {
                        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case DOWN: {
                        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case NORTH: {
                        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case SOUTH: {
                        GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case EAST: {
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case WEST: {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                }
                this.renderSign(pipe, pair.getValue2(), partialTickTime);
                GL11.glPopMatrix();
            }
        }
    }

    private void renderSign(CoreRoutedPipe pipe, IPipeSign type, float partialTickTime) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)32826);
        float signScale = 0.6666667f;
        GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.36f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SIGN);
        GL11.glPushMatrix();
        GL11.glScalef((float)signScale, (float)(-signScale), (float)(-signScale));
        this.modelSign.func_78164_a();
        GL11.glPopMatrix();
        GL11.glTranslatef((float)-0.32f, (float)(0.5f * signScale + 0.08f), (float)(0.07f * signScale));
        type.render(pipe, this);
    }

    public void renderItemStackOnSign(@Nonnull ItemStack itemstack) {
        long start = System.nanoTime();
        this.renderItemStackOnSignInner(itemstack);
        long end = System.nanoTime();
        this.renderItemStackOnSignPerfMeter.newPerfValue(end - start);
    }

    private void renderItemStackOnSignInner(@Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        RenderItem itemRender = mc.func_175599_af();
        GlStateManager.func_179140_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        itemRender.field_77023_b = 100.0f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        mc.field_71446_o.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        IBakedModel bakedModel = itemModelMesher.func_178089_a(itemstack);
        bakedModel = bakedModel.func_188617_f().handleItemState(bakedModel, itemstack, null, null);
        GlStateManager.func_179109_b((float)0.05f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.001f);
        bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
        itemRender.func_180454_a(itemstack, bakedModel);
        GlStateManager.func_179101_C();
        GlStateManager.func_179118_c();
        GlStateManager.func_179121_F();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        mc.field_71446_o.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        itemRender.field_77023_b = 0.0f;
    }

    public String cut(String name, FontRenderer renderer) {
        if (renderer.func_78256_a(name) < 90) {
            return name;
        }
        StringBuilder sum = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (renderer.func_78256_a(sum.toString() + name.charAt(i) + "...") >= 90) {
                return sum.toString() + "...";
            }
            sum.append(name.charAt(i));
        }
        return sum.toString();
    }
}

