/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import logisticspipes.LPBlocks;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.items.ItemLogisticsPipe;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.LogisticsGuiOverrenderer;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.debug.ClientViewController;
import logisticspipes.utils.LPPositionSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.DoubleCoordinatesType;
import org.lwjgl.opengl.GL11;

public class RenderTickHandler {
    private long renderTicks = 0L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (LogisticsGuiOverrenderer.getInstance().isCompatibleGui()) {
                LogisticsGuiOverrenderer.getInstance().preRender();
            }
            ClientViewController.instance().tick();
        } else {
            ++this.renderTicks;
            if (LogisticsHUDRenderer.instance().displayRenderer()) {
                GL11.glPushMatrix();
                Minecraft mc = FMLClientHandler.instance().getClient();
                mc.field_71460_t.func_78479_a(event.renderTickTime, 1);
                ActiveRenderInfo.func_74583_a((EntityPlayer)mc.field_71439_g, (mc.field_71474_y.field_74320_O == 2 ? 1 : 0) != 0);
                LogisticsHUDRenderer.instance().renderWorldRelative(this.renderTicks, event.renderTickTime);
                mc.field_71460_t.func_78478_c();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                LogisticsHUDRenderer.instance().renderPlayerDisplay(this.renderTicks);
                GL11.glPopMatrix();
            } else if (LogisticsGuiOverrenderer.getInstance().isCompatibleGui()) {
                LogisticsGuiOverrenderer.getInstance().renderOverGui();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderWorldLast(RenderWorldLastEvent worldEvent) {
        double z;
        double y;
        double x;
        if (!this.displayPipeGhost()) return;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        RayTraceResult box = mc.field_71476_x;
        if (box == null) return;
        if (box.field_72313_a != RayTraceResult.Type.BLOCK) return;
        ItemStack stack = (ItemStack)FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70462_a.get(FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70461_c);
        CoreUnroutedPipe pipe = ((ItemLogisticsPipe)stack.func_77973_b()).getDummyPipe();
        World world = player.func_130014_f_();
        EnumFacing side = box.field_178784_b;
        BlockPos bPos = box.func_178782_a();
        Block block = world.func_180495_p(bPos).func_177230_c();
        if (block == Blocks.field_150431_aC && block.func_176200_f((IBlockAccess)world, bPos)) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)world, bPos)) {
            bPos = bPos.func_177972_a(side);
        }
        boolean isFreeSpace = true;
        ITubeOrientation orientation = null;
        if (pipe instanceof CoreMultiBlockPipe) {
            CoreMultiBlockPipe multipipe = (CoreMultiBlockPipe)pipe;
            DoubleCoordinates placeAt = new DoubleCoordinates(bPos);
            LPPositionSet globalPos = new LPPositionSet(DoubleCoordinatesType.class);
            globalPos.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(placeAt, CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
            LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> positions = multipipe.getSubBlocks();
            orientation = multipipe.getTubeOrientation((EntityPlayer)player, bPos.func_177958_n(), bPos.func_177952_p());
            if (orientation == null) return;
            orientation.rotatePositions(positions);
            positions.stream().map(pos -> pos.add(placeAt)).forEach(globalPos::add);
            globalPos.addToAll(orientation.getOffset());
            for (DoubleCoordinatesType pos2 : globalPos) {
                if (player.func_130014_f_().func_190527_a((Block)LPBlocks.pipe, pos2.getBlockPos(), false, side, (Entity)player)) continue;
                TileEntity tile = player.func_130014_f_().func_175625_s(pos2.getBlockPos());
                boolean canPlace = false;
                if (tile instanceof LogisticsTileGenericSubMultiBlock && CoreMultiBlockPipe.canShare(((LogisticsTileGenericSubMultiBlock)tile).getSubTypes(), (CoreMultiBlockPipe.SubBlockTypeForShare)((Object)pos2.getType()))) {
                    canPlace = true;
                }
                if (canPlace) continue;
                return;
            }
        } else if (!player.func_130014_f_().func_190527_a((Block)LPBlocks.pipe, bPos, false, side, (Entity)player)) {
            return;
        }
        if (!isFreeSpace) return;
        GlStateManager.func_179094_E();
        if (orientation != null) {
            x = (double)(bPos.func_177958_n() + orientation.getOffset().getXInt()) - player.field_70169_q - (player.field_70165_t - player.field_70169_q) * (double)worldEvent.getPartialTicks();
            y = (double)(bPos.func_177956_o() + orientation.getOffset().getYInt()) - player.field_70167_r - (player.field_70163_u - player.field_70167_r) * (double)worldEvent.getPartialTicks();
            z = (double)(bPos.func_177952_p() + orientation.getOffset().getZInt()) - player.field_70166_s - (player.field_70161_v - player.field_70166_s) * (double)worldEvent.getPartialTicks();
        } else {
            x = (double)bPos.func_177958_n() - player.field_70169_q - (player.field_70165_t - player.field_70169_q) * (double)worldEvent.getPartialTicks();
            y = (double)bPos.func_177956_o() - player.field_70167_r - (player.field_70163_u - player.field_70167_r) * (double)worldEvent.getPartialTicks();
            z = (double)bPos.func_177952_p() - player.field_70166_s - (player.field_70161_v - player.field_70166_s) * (double)worldEvent.getPartialTicks();
        }
        GL11.glTranslated((double)(x + 0.001), (double)(y + 0.001), (double)(z + 0.001));
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71446_o.func_110577_a(new ResourceLocation("logisticspipes", "textures/blocks/pipes/white.png"));
        SimpleServiceLocator.cclProxy.getRenderState().reset();
        SimpleServiceLocator.cclProxy.getRenderState().setAlphaOverride(255);
        GlStateManager.func_179098_w();
        SimpleServiceLocator.cclProxy.getRenderState().setAlphaOverride(80);
        SimpleServiceLocator.cclProxy.getRenderState().startDrawing(7, DefaultVertexFormats.field_176600_a);
        pipe.getHighlightRenderer().renderHighlight(orientation);
        SimpleServiceLocator.cclProxy.getRenderState().draw();
        SimpleServiceLocator.cclProxy.getRenderState().setAlphaOverride(255);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private boolean displayPipeGhost() {
        return FMLClientHandler.instance().getClient().field_71439_g != null && FMLClientHandler.instance().getClient().field_71439_g.field_71071_by != null && FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70462_a != null && FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70462_a.size() > FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70461_c && !((ItemStack)FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70462_a.get(FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70461_c)).func_190926_b() && this.checkItemStackForPipeGhost((ItemStack)FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70462_a.get(FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70461_c));
    }

    private boolean checkItemStackForPipeGhost(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemLogisticsPipe;
    }
}

