/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Locale;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.input.Keyboard;

public class InputBar {
    public int minNumber = 0;
    public String input1 = "";
    public String input2 = "";
    private boolean isActive = false;
    private boolean displaycursor = true;
    private long oldSystemTime = 0L;
    private int searchWidth = 150;
    private boolean numberOnly = false;
    private Align align = Align.LEFT;
    private final FontRenderer fontRenderer;
    private final LogisticsBaseGuiScreen screen;
    private int left;
    private int top;
    private int heigth;
    private int width;

    public InputBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int heigth) {
        this(fontRenderer, screen, left, top, width, heigth, true);
    }

    public InputBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int heigth, boolean isActive) {
        this(fontRenderer, screen, left, top, width, heigth, isActive, false);
    }

    public InputBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int heigth, boolean isActive, boolean numberOnly) {
        this(fontRenderer, screen, left, top, width, heigth, isActive, numberOnly, Align.LEFT);
    }

    public InputBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int heigth, boolean isActive, boolean numberOnly, Align align) {
        this.fontRenderer = fontRenderer;
        this.screen = screen;
        this.left = left;
        this.top = top;
        this.width = width;
        this.heigth = heigth;
        this.searchWidth = width - (int)(4.5f + (float)(this.heigth - 9) / 2.0f);
        this.isActive = isActive;
        this.numberOnly = numberOnly;
        this.align = align;
    }

    public void reposition(int left, int top, int width, int heigth) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.heigth = heigth;
        this.searchWidth = width - (int)(4.5f + (float)(this.heigth - 9) / 2.0f);
    }

    public void renderSearchBar() {
        if (this.isFocused()) {
            this.screen.drawRect(this.left + 0, this.top - 2, this.left + this.width - 0, this.top + this.heigth - 0, Color.BLACK);
            this.screen.drawRect(this.left + 1, this.top - 1, this.left + this.width - 1, this.top + this.heigth - 1, Color.WHITE);
        } else {
            this.screen.drawRect(this.left + 1, this.top - 1, this.left + this.width - 1, this.top + this.heigth - 1, Color.BLACK);
        }
        this.screen.drawRect(this.left + 2, this.top - 0, this.left + this.width - 2, this.top + this.heigth - 2, Color.DARKER_GREY);
        if (this.align == Align.RIGHT) {
            this.fontRenderer.func_175065_a(this.input1 + this.input2, (float)(this.left + 2) + (float)(this.heigth - 9) / 2.0f + (float)this.searchWidth - (float)this.fontRenderer.func_78256_a(this.input1 + this.input2), (float)this.top + (float)(this.heigth - 9) / 2.0f, 0xFFFFFF, false);
        } else if (this.align == Align.CENTER) {
            this.fontRenderer.func_175065_a(this.input1 + this.input2, (float)(this.left + 2) + (float)(this.heigth - 9) / 2.0f + (float)(this.searchWidth - this.fontRenderer.func_78256_a(this.input1 + this.input2)) / 2.0f, (float)this.top + (float)(this.heigth - 9) / 2.0f, 0xFFFFFF, false);
        } else {
            this.fontRenderer.func_175065_a(this.input1 + this.input2, (float)(this.left + 2) + (float)(this.heigth - 9) / 2.0f, (float)this.top + (float)(this.heigth - 9) / 2.0f, 0xFFFFFF, false);
        }
        if (this.isFocused()) {
            float linex = 0.0f;
            linex = this.align == Align.RIGHT ? (float)(this.left + 2) + (float)(this.heigth - 9) / 2.0f + (float)this.searchWidth - (float)this.fontRenderer.func_78256_a(this.input2) : (this.align == Align.CENTER ? (float)(this.left + 2) + (float)(this.heigth - 9) / 2.0f + (float)(this.searchWidth - this.fontRenderer.func_78256_a(this.input2)) / 2.0f + (float)this.fontRenderer.func_78256_a(this.input1) / 2.0f : (float)(this.left + 2) + (float)(this.heigth - 9) / 2.0f + (float)this.fontRenderer.func_78256_a(this.input1));
            if (System.currentTimeMillis() - this.oldSystemTime > 500L) {
                this.displaycursor = !this.displaycursor;
                this.oldSystemTime = System.currentTimeMillis();
            }
            if (this.displaycursor) {
                this.screen.drawRect((int)linex, this.top + 1, (int)(linex + 1.0f), this.top + this.heigth - 3, Color.WHITE);
            }
        }
    }

    public boolean handleClick(int x, int y, int k) {
        if (x >= this.left + 2 && x < this.left + this.width - 2 && y >= this.top && y < this.top + this.heigth) {
            this.focus();
            if (k == 1) {
                this.input1 = "";
                this.input2 = "";
            }
            return true;
        }
        if (this.isFocused()) {
            this.unFocus();
            return true;
        }
        return false;
    }

    private void unFocus() {
        this.isActive = false;
        if (this.numberOnly) {
            this.input1 = this.input1 + this.input2;
            this.input2 = "";
            try {
                int value = Integer.valueOf(this.input1);
                value = Math.max(value, this.minNumber);
                this.input1 = Integer.toString(value);
            }
            catch (Exception e) {
                this.input1 = "";
            }
            if (this.input1.isEmpty() && this.input2.isEmpty()) {
                this.input1 = Integer.toString(this.minNumber);
            }
        }
    }

    private void focus() {
        this.isActive = true;
    }

    public boolean isFocused() {
        return this.isActive;
    }

    public boolean handleKey(char c, int i) {
        if (!this.isFocused()) {
            return false;
        }
        if (i == 1) {
            return false;
        }
        if (c == '\r' || i == 28) {
            this.unFocus();
        } else if (c == '\b' || i == 14 && System.getProperty("os.name").toLowerCase(Locale.US).contains("mac")) {
            if (this.input1.length() > 0) {
                this.input1 = this.input1.substring(0, this.input1.length() - 1);
            }
        } else if (i == 203) {
            if (this.input1.length() > 0) {
                this.input2 = this.input1.substring(this.input1.length() - 1) + this.input2;
                this.input1 = this.input1.substring(0, this.input1.length() - 1);
            }
        } else if (i == 205) {
            if (this.input2.length() > 0) {
                this.input1 = this.input1 + this.input2.substring(0, 1);
                this.input2 = this.input2.substring(1);
            }
        } else if (i == 199) {
            this.input2 = this.input1 + this.input2;
            this.input1 = "";
        } else if (i == 207) {
            this.input1 = this.input1 + this.input2;
            this.input2 = "";
        } else if (i == 211) {
            if (this.input2.length() > 0) {
                this.input2 = this.input2.substring(1);
            }
        } else if (i == 47 && Keyboard.isKeyDown((int)29)) {
            boolean isFine = true;
            if (this.numberOnly) {
                try {
                    Integer.valueOf(InputBar.getClipboardString());
                }
                catch (Exception e) {
                    isFine = false;
                }
            }
            if (isFine) {
                String toAdd = InputBar.getClipboardString();
                while (this.fontRenderer.func_78256_a(this.input1 + toAdd + this.input2) > this.searchWidth) {
                    toAdd = toAdd.substring(0, toAdd.length() - 1);
                }
                this.input1 = this.input1 + toAdd;
            }
        } else if ((!this.numberOnly && !Character.isISOControl(c) || this.numberOnly && Character.isDigit(c)) && this.fontRenderer.func_78256_a(this.input1 + c + this.input2) <= this.searchWidth) {
            this.input1 = this.input1 + c;
        }
        return true;
    }

    public String getContent() {
        return this.input1 + this.input2;
    }

    public boolean isEmpty() {
        return this.input1.isEmpty() && this.input2.isEmpty();
    }

    private static String getClipboardString() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

