/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.ISaveState;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.items.ItemStackLoader;

public class SimpleStackInventory
implements IInventory,
ISaveState,
Iterable<Pair<ItemStack, Integer>> {
    private ItemStack[] _contents;
    private final String _name;
    private final int _stackLimit;
    private final LinkedList<ISimpleInventoryEventHandler> _listener = new LinkedList();

    public SimpleStackInventory(int size, String name, int stackLimit) {
        this._contents = new ItemStack[size];
        Arrays.fill(this._contents, ItemStack.field_190927_a);
        this._name = name;
        this._stackLimit = stackLimit;
    }

    public int func_70302_i_() {
        return this._contents.length;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this._contents) {
            if (stack != null && stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int i) {
        return this._contents[i] != null ? this._contents[i] : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (this._contents[slot].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this._contents[slot].func_190916_E() > count) {
            ItemStack ret = this._contents[slot].func_77946_l();
            ret.func_190920_e(count);
            this._contents[slot].func_190920_e(this._contents[slot].func_190916_E() - count);
            return ret;
        }
        ItemStack ret = this._contents[slot];
        this._contents[slot] = ItemStack.field_190927_a;
        return ret;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this._contents[i] = !itemstack.func_190926_b() ? itemstack.func_77946_l() : ItemStack.field_190927_a;
    }

    public String func_70005_c_() {
        return this._name;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return this._stackLimit;
    }

    public void func_70296_d() {
        for (ISimpleInventoryEventHandler handler : this._listener) {
            handler.InventoryChanged(this);
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound, "");
    }

    public void readFromNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(prefix + "items", (int)nbttagcompound.func_74732_a());
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(j);
            int index = nbttagcompound2.func_74762_e("index");
            if (index < this._contents.length) {
                this._contents[index] = ItemStackLoader.loadAndFixItemStackFromNBT(nbttagcompound2);
                continue;
            }
            LogisticsPipes.log.fatal("SimpleInventory: java.lang.ArrayIndexOutOfBoundsException: " + index + " of " + this._contents.length);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.writeToNBT(nbttagcompound, "");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < this._contents.length; ++j) {
            if (this._contents[j] == null || this._contents[j].func_190926_b() || this._contents[j].func_190916_E() <= 0) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            nbttagcompound2.func_74768_a("index", j);
            this._contents[j].func_77955_b(nbttagcompound2);
        }
        nbttagcompound.func_74782_a(prefix + "items", (NBTBase)nbttaglist);
        nbttagcompound.func_74768_a(prefix + "itemsCount", this._contents.length);
    }

    public void dropContents(World world, BlockPos pos) {
        this.dropContents(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void dropContents(World world, int posX, int posY, int posZ) {
        if (MainProxy.isServer((IBlockAccess)world)) {
            for (int i = 0; i < this._contents.length; ++i) {
                while (this._contents[i] != null && !this._contents[i].func_190926_b()) {
                    ItemStack todrop = this.func_70298_a(i, this._contents[i].func_77976_d());
                    this.dropItems(world, todrop, posX, posY, posZ);
                }
            }
        }
    }

    private void dropItems(World world, ItemStack stack, int i, int j, int k) {
        if (stack.func_190916_E() <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.func_174869_p();
        world.func_72838_d((Entity)entityitem);
    }

    public void addListener(ISimpleInventoryEventHandler listner) {
        if (!this._listener.contains(listner)) {
            this._listener.add(listner);
        }
    }

    public void removeListener(ISimpleInventoryEventHandler listner) {
        if (this._listener.contains(listner)) {
            this._listener.remove(listner);
        }
    }

    public ItemStack func_70304_b(int i) {
        if (this._contents[i].func_190926_b()) {
            return null;
        }
        ItemStack stackToTake = this._contents[i];
        this._contents[i] = ItemStack.field_190927_a;
        return stackToTake;
    }

    private int tryAddToSlot(int i, ItemStack stack, int realstacklimit) {
        ItemStack slot = this._contents[i];
        if (slot.func_190926_b()) {
            this._contents[i] = stack.func_77946_l();
            this._contents[i].func_190920_e(Math.min(this._contents[i].func_190916_E(), realstacklimit));
            return this._contents[i].func_190916_E();
        }
        ItemIdentifier stackIdent = ItemIdentifier.get(stack);
        ItemIdentifier slotIdent = ItemIdentifier.get(slot);
        if (slotIdent.equals(stackIdent)) {
            slot.func_190920_e(slot.func_190916_E() + stack.func_190916_E());
            if (slot.func_190916_E() > realstacklimit) {
                int ans = stack.func_190916_E() - (slot.func_190916_E() - realstacklimit);
                slot.func_190920_e(realstacklimit);
                return ans;
            }
            return stack.func_190916_E();
        }
        return 0;
    }

    public int addCompressed(ItemStack stack, boolean ignoreMaxStackSize) {
        int added;
        int i;
        if (stack.func_190926_b()) {
            return 0;
        }
        stack = stack.func_77946_l();
        ItemIdentifier stackIdent = ItemIdentifier.get(stack);
        int stacklimit = this._stackLimit;
        if (!ignoreMaxStackSize) {
            stacklimit = Math.min(stacklimit, stackIdent.getMaxStackSize());
        }
        for (i = 0; i < this._contents.length && stack.func_190916_E() > 0; ++i) {
            if (this._contents[i].func_190926_b()) continue;
            added = this.tryAddToSlot(i, stack, stacklimit);
            stack.func_190920_e(stack.func_190916_E() - added);
        }
        for (i = 0; i < this._contents.length && stack.func_190916_E() > 0; ++i) {
            added = this.tryAddToSlot(i, stack, stacklimit);
            stack.func_190920_e(stack.func_190916_E() - added);
        }
        this.func_70296_d();
        return stack.func_190916_E();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void clearInventorySlotContents(int i) {
        this._contents[i] = null;
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public Iterator<Pair<ItemStack, Integer>> iterator() {
        final Iterator<ItemStack> iter = Arrays.asList(this._contents).iterator();
        return new Iterator<Pair<ItemStack, Integer>>(){
            int pos = -1;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Pair<ItemStack, Integer> next() {
                ++this.pos;
                return new Pair<ItemStack, Integer>((ItemStack)iter.next(), this.pos);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

