/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.math;

import java.beans.ConstructorProperties;

public class Vector2d {
    public double x;
    public double y;

    public Vector2d(Vector2d vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
    }

    public Vector2d multiply(double i) {
        this.x *= i;
        this.y *= i;
        return this;
    }

    public double abs() {
        return Math.hypot(this.x, this.y);
    }

    public Vector2d add(Vector2d vector, double factor) {
        Vector2d lVector = vector.clone().makeVectorLength(factor);
        this.x += lVector.x;
        this.y += lVector.y;
        return this;
    }

    public Vector2d add(Vector2d vector) {
        this.x += vector.x;
        this.y += vector.y;
        return this;
    }

    public Vector2d sub(Vector2d vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        return this;
    }

    public Vector2d reverse() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2d makeVectorLength(double length) {
        double divide = Math.sqrt(Math.pow(this.abs(), 2.0) / Math.pow(length, 2.0));
        double multiply = 1.0 / divide;
        this.x *= multiply;
        this.y *= multiply;
        return this;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "]" + "(" + this.abs() + ")";
    }

    public Vector2d clone() {
        Vector2d vector = new Vector2d();
        vector.x = this.x;
        vector.y = this.y;
        return vector;
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void set(Vector2d vector3d) {
        this.set(vector3d.x, vector3d.y);
    }

    @ConstructorProperties(value={"x", "y"})
    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2d() {
    }
}

