/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.math;

import java.beans.ConstructorProperties;

public class Vector2f {
    public float x;
    public float y;

    public Vector2f(Vector2f vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
    }

    public Vector2f multiply(double i) {
        this.x = (float)((double)this.x * i);
        this.y = (float)((double)this.y * i);
        return this;
    }

    public double abs() {
        return Math.hypot(this.x, this.y);
    }

    public Vector2f add(Vector2f vector, double factor) {
        Vector2f lVector = vector.clone().makeVectorLength(factor);
        this.x += lVector.x;
        this.y += lVector.y;
        return this;
    }

    public Vector2f add(Vector2f vector) {
        this.x += vector.x;
        this.y += vector.y;
        return this;
    }

    public Vector2f sub(Vector2f vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        return this;
    }

    public Vector2f reverse() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f makeVectorLength(double length) {
        double divide = Math.sqrt(Math.pow(this.abs(), 2.0) / Math.pow(length, 2.0));
        double multiply = 1.0 / divide;
        this.x = (float)((double)this.x * multiply);
        this.y = (float)((double)this.y * multiply);
        return this;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "]" + "(" + this.abs() + ")";
    }

    public Vector2f clone() {
        Vector2f vector = new Vector2f();
        vector.x = this.x;
        vector.y = this.y;
        return vector;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Vector2f vector3d) {
        this.set(vector3d.x, vector3d.y);
    }

    @ConstructorProperties(value={"x", "y"})
    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f() {
    }
}

