/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.debug;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\f\u00a8\u0006\u001a"}, d2={"Lnetwork/rs485/debug/PerformanceMeter;", "", "label", "", "meanCalcCallCount", "", "printToConsole", "", "(Ljava/lang/String;IZ)V", "calculatedMean", "Ljava/time/Duration;", "getCalculatedMean", "()Ljava/time/Duration;", "currentGroupIndex", "getLabel", "()Ljava/lang/String;", "meanCalcGroup", "", "sum", "getSum", "increaseGroupIndex", "", "newPerfValue", "duration", "nanoDuration", "", "logisticspipes"})
public final class PerformanceMeter {
    private final long[] meanCalcGroup;
    private int currentGroupIndex;
    @NotNull
    private final String label;
    private final int meanCalcCallCount;
    private final boolean printToConsole;

    @NotNull
    public final Duration getSum() {
        Duration duration;
        long durationSum = ArraysKt.sum((long[])this.meanCalcGroup);
        if (durationSum == 0L) {
            Duration duration2 = Duration.ZERO;
            duration = duration2;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ZERO");
        } else {
            Duration duration3 = Duration.ofNanos(durationSum);
            duration = duration3;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofNanos(durationSum)");
        }
        return duration;
    }

    @NotNull
    public final Duration getCalculatedMean() {
        Duration duration = this.getSum().dividedBy(this.meanCalcCallCount);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"sum.dividedBy(meanCalcCallCount.toLong())");
        return duration;
    }

    private final void increaseGroupIndex() {
        int n = this.currentGroupIndex;
        this.currentGroupIndex = n + 1;
        if (this.currentGroupIndex >= this.meanCalcCallCount) {
            this.currentGroupIndex = 0;
            if (this.printToConsole) {
                String string = "[PerformanceMeter." + this.label + "] Sum: " + this.getSum() + " of " + this.meanCalcCallCount + " measures - Mean time: " + this.getCalculatedMean();
                boolean bl = false;
                System.out.println((Object)string);
            }
        }
    }

    public final void newPerfValue(long nanoDuration) {
        this.meanCalcGroup[this.currentGroupIndex] = nanoDuration;
        this.increaseGroupIndex();
    }

    public final void newPerfValue(@NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        this.newPerfValue(duration.toNanos());
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public PerformanceMeter(@NotNull String label, int meanCalcCallCount, boolean printToConsole) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        this.label = label;
        this.meanCalcCallCount = meanCalcCallCount;
        this.printToConsole = printToConsole;
        this.meanCalcGroup = new long[this.meanCalcCallCount];
        this.currentGroupIndex = 0;
    }
}

