/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.BOPGeneratorBase;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorBigFlower
extends BOPGeneratorBase {
    protected static IBlockState stem = BlockBOPLog.paging.getVariantState(BOPWoods.GIANT_FLOWER);
    protected IBlockPosQuery placeOn;
    protected IBlockPosQuery replace;
    protected BigFlowerType flowerType;
    protected IBlockState petalState;

    public GeneratorBigFlower(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, BigFlowerType flowerType) {
        super(amountPerChunk);
        this.placeOn = placeOn;
        this.replace = replace;
        this.setFlowerType(flowerType);
    }

    public void setFlowerType(BigFlowerType type) {
        this.flowerType = type;
        switch (type) {
            case RED: {
                this.petalState = BlockBOPLeaves.paging.getVariantState(BOPTrees.RED_BIG_FLOWER);
                break;
            }
            case YELLOW: {
                this.petalState = BlockBOPLeaves.paging.getVariantState(BOPTrees.YELLOW_BIG_FLOWER);
            }
        }
        this.petalState = this.petalState.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockPos getScatterY(World world, Random random, int x, int z) {
        return GeneratorUtils.ScatterYMethod.AT_SURFACE.getBlockPos(world, random, x, z);
    }

    public boolean isEnoughSpace(World world, BlockPos pos) {
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + 8 > 255) {
            return false;
        }
        for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 8; ++y) {
            int radius = y <= pos.func_177956_o() + 4 ? 0 : 2;
            for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
                for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                    if (this.replace.matches(world, new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean setStem(World world, BlockPos pos) {
        return this.setStem(world, pos, EnumFacing.Axis.Y);
    }

    public boolean setStem(World world, BlockPos pos, EnumFacing.Axis axis) {
        IBlockState directedStem;
        IBlockState iBlockState = directedStem = axis == null ? stem : stem.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)axis));
        if (this.replace.matches(world, pos)) {
            world.func_180501_a(pos, directedStem, 2);
            return true;
        }
        return false;
    }

    public boolean setPetal(World world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            world.func_180501_a(pos, this.petalState, 2);
            return true;
        }
        return false;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (!this.isEnoughSpace(world, pos)) {
            return false;
        }
        if (!this.placeOn.matches(world, pos.func_177977_b())) {
            return false;
        }
        world.func_180495_p(pos.func_177977_b()).func_177230_c().onPlantGrow(world.func_180495_p(pos.func_177977_b()), world, pos.func_177977_b(), pos);
        this.setStem(world, pos);
        this.setStem(world, pos.func_177981_b(1));
        this.setStem(world, pos.func_177981_b(2));
        this.setStem(world, pos.func_177981_b(3));
        this.setStem(world, pos.func_177981_b(4));
        switch (this.flowerType) {
            case RED: {
                this.setPetal(world, pos.func_177982_a(-1, 4, 0));
                this.setPetal(world, pos.func_177982_a(1, 4, 0));
                this.setPetal(world, pos.func_177982_a(0, 4, -1));
                this.setPetal(world, pos.func_177982_a(0, 4, 1));
                this.setPetal(world, pos.func_177982_a(0, 5, 0));
                this.setPetal(world, pos.func_177982_a(-1, 5, 0));
                this.setPetal(world, pos.func_177982_a(1, 5, 0));
                this.setPetal(world, pos.func_177982_a(0, 5, -1));
                this.setPetal(world, pos.func_177982_a(0, 5, 1));
                this.setPetal(world, pos.func_177982_a(1, 5, 1));
                this.setPetal(world, pos.func_177982_a(1, 5, -1));
                this.setPetal(world, pos.func_177982_a(-1, 5, 1));
                this.setPetal(world, pos.func_177982_a(-1, 5, -1));
                this.setPetal(world, pos.func_177982_a(2, 5, 0));
                this.setPetal(world, pos.func_177982_a(-2, 5, 0));
                this.setPetal(world, pos.func_177982_a(0, 5, 2));
                this.setPetal(world, pos.func_177982_a(0, 5, -2));
                this.setPetal(world, pos.func_177982_a(1, 6, 1));
                this.setPetal(world, pos.func_177982_a(1, 6, -1));
                this.setPetal(world, pos.func_177982_a(-1, 6, 1));
                this.setPetal(world, pos.func_177982_a(-1, 6, -1));
                this.setPetal(world, pos.func_177982_a(2, 6, 0));
                this.setPetal(world, pos.func_177982_a(-2, 6, 0));
                this.setPetal(world, pos.func_177982_a(0, 6, 2));
                this.setPetal(world, pos.func_177982_a(0, 6, -2));
                this.setPetal(world, pos.func_177982_a(2, 6, 2));
                this.setPetal(world, pos.func_177982_a(2, 6, -2));
                this.setPetal(world, pos.func_177982_a(-2, 6, 2));
                this.setPetal(world, pos.func_177982_a(-2, 6, -2));
                this.setPetal(world, pos.func_177982_a(2, 7, 0));
                this.setPetal(world, pos.func_177982_a(-2, 7, 0));
                this.setPetal(world, pos.func_177982_a(0, 7, 2));
                this.setPetal(world, pos.func_177982_a(0, 7, -2));
                this.setPetal(world, pos.func_177982_a(3, 8, 0));
                this.setPetal(world, pos.func_177982_a(-3, 8, 0));
                this.setPetal(world, pos.func_177982_a(0, 8, 3));
                this.setPetal(world, pos.func_177982_a(0, 8, -3));
                break;
            }
            case YELLOW: {
                this.setPetal(world, pos.func_177982_a(-1, 4, 0));
                this.setPetal(world, pos.func_177982_a(1, 4, 0));
                this.setPetal(world, pos.func_177982_a(0, 4, -1));
                this.setPetal(world, pos.func_177982_a(0, 4, 1));
                this.setPetal(world, pos.func_177982_a(2, 4, 2));
                this.setPetal(world, pos.func_177982_a(2, 4, -2));
                this.setPetal(world, pos.func_177982_a(-2, 4, 2));
                this.setPetal(world, pos.func_177982_a(-2, 4, -2));
                this.setPetal(world, pos.func_177982_a(0, 5, 0));
                this.setPetal(world, pos.func_177982_a(-1, 5, 0));
                this.setPetal(world, pos.func_177982_a(1, 5, 0));
                this.setPetal(world, pos.func_177982_a(0, 5, -1));
                this.setPetal(world, pos.func_177982_a(0, 5, 1));
                this.setPetal(world, pos.func_177982_a(1, 5, 1));
                this.setPetal(world, pos.func_177982_a(1, 5, -1));
                this.setPetal(world, pos.func_177982_a(-1, 5, 1));
                this.setPetal(world, pos.func_177982_a(-1, 5, -1));
                this.setPetal(world, pos.func_177982_a(2, 5, 0));
                this.setPetal(world, pos.func_177982_a(-2, 5, 0));
                this.setPetal(world, pos.func_177982_a(0, 5, 2));
                this.setPetal(world, pos.func_177982_a(0, 5, -2));
                this.setPetal(world, pos.func_177982_a(0, 6, 0));
                this.setPetal(world, pos.func_177982_a(3, 6, 0));
                this.setPetal(world, pos.func_177982_a(-3, 6, 0));
                this.setPetal(world, pos.func_177982_a(0, 6, 3));
                this.setPetal(world, pos.func_177982_a(0, 6, -3));
            }
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.setFlowerType(conf.getEnum("type", this.flowerType, BigFlowerType.class));
    }

    public static class Builder
    extends BOPGeneratorBase.InnerBuilder<Builder, GeneratorBigFlower>
    implements IGenerator.IGeneratorBuilder<GeneratorBigFlower> {
        protected BigFlowerType flowerType;
        protected IBlockPosQuery placeOn;
        protected IBlockPosQuery replace;

        public Builder flowerType(BigFlowerType a) {
            this.flowerType = a;
            return this;
        }

        public Builder placeOn(IBlockPosQuery a) {
            this.placeOn = a;
            return (Builder)this.self();
        }

        public Builder placeOn(String a) throws BlockQuery.BlockQueryParseException {
            this.placeOn = BlockQuery.parseQueryString(a);
            return (Builder)this.self();
        }

        public Builder placeOn(Block a) {
            this.placeOn = new BlockQuery.BlockQueryBlock(a);
            return (Builder)this.self();
        }

        public Builder placeOn(IBlockState a) {
            this.placeOn = new BlockQuery.BlockQueryState(a);
            return (Builder)this.self();
        }

        public Builder replace(IBlockPosQuery a) {
            this.replace = a;
            return (Builder)this.self();
        }

        public Builder replace(String a) throws BlockQuery.BlockQueryParseException {
            this.replace = BlockQuery.parseQueryString(a);
            return (Builder)this.self();
        }

        public Builder replace(Block a) {
            this.replace = new BlockQuery.BlockQueryBlock(a);
            return (Builder)this.self();
        }

        public Builder replace(IBlockState a) {
            this.replace = new BlockQuery.BlockQueryState(a);
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.flowerType = BigFlowerType.RED;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.airOrLeaves;
        }

        @Override
        public GeneratorBigFlower create() {
            return new GeneratorBigFlower(this.amountPerChunk, this.placeOn, this.replace, this.flowerType);
        }
    }

    public static enum BigFlowerType {
        RED,
        YELLOW;

    }
}

