package csokicraft.util;

import java.io.*;
import java.util.*;

/** A stream that buffers up any input given to its {@link OutputStream} [{@link #getOutputStream()}],
  * and delivers it to its {@link InputStream} [{@link #getInputStream()}]
  * @author CsokiCraft*/
public class QueuedStream {
	protected class QueuedInputStream extends InputStream{
		QueuedStream qs;
		public QueuedInputStream(QueuedStream str) {
			qs=str;
		}
		@Override
		public int read() throws IOException {
			return qs.read();
		}
		
	}
	protected class QueuedOutputStream extends OutputStream{
		QueuedStream qs;
		
		public QueuedOutputStream(QueuedStream str) {
			qs=str;
		}

		@Override
		public void write(int arg0) throws IOException {
			qs.write(arg0);
		}
	}
	Queue<Integer> q;
	
	/** Creates a QueuedStream with a given buffer size
	  * @param len The buffer size*/
	public QueuedStream(int len){
		q=new ArrayDeque<>(len);
		
	}
	
	/** Creates a QueuedStream with the default buffersize of 1k. (1024 integer places)*/
	public QueuedStream() {
		this(1024);
	}
	
	public void write(int b) throws IOException{
		if(!q.offer(b)) throw new IOException("The queue was not able to handle "+b);
	}

	public int read() throws IOException {
		if(!ready()) throw new IOException("The queue was empty when a read operation occured. Please use QueuedStream.ready()");
		else return q.poll();
	}

	public boolean ready() {
		return !q.isEmpty();
	}
	
	public InputStream getInputStream(){
		return new QueuedInputStream(this);
	}
	
	public OutputStream getOutputStream(){
		return new QueuedOutputStream(this);
	}
}
