package csokicraft.util.eqdf.compile;

import java.util.*;

import csokicraft.util.eqdf.MathContext;
import static csokicraft.util.eqdf.compile.EqdfInstructionSet.*;

/** The original implementation of {@link IEqdfCompiler} <br>
  * Doesn't support 2-sided equations, only assignments.
  * @author CsokiCraft */
public class EqdfCompiler implements IEqdfCompiler{
	private int last_pID = 0;
	
	@Override
	public void clean(){
		last_pID = 0;
	}
	
	@Override
	public MathContext compile(String s){
		List<Object> l = new ArrayList<Object>();
		MathContext ctx = new MathContext(l);
		int middle = s.indexOf('=');
		compileRHS(s.substring(middle+1), l);
		if(middle>0) compileLHS(s.substring(0, middle), l);
		return ctx;
	}
	
	private void compileRHS(String rhs, List<Object> l){
		l.addAll(compilerSubroutine(rhs, 0));
	}
	
	private void compileLHS(String lhs, List<Object> l) {
		char curVar = lhs.charAt(1);
		l.add(ST_VAR);
		l.add(curVar);
	}
	
	private List<Object> compilerSubroutine(String s, int pID){
		List<Object> l = new ArrayList<Object>();
		compiling:for(int idx=0;idx<s.length();idx++){
			char rd = s.charAt(idx);
			
			if(isNumberConst(rd)){ //parse number
				StringBuilder sb = new StringBuilder();
				while(idx < s.length() && isNumberConst(rd = s.charAt(idx))){
					sb.append(rd);
					idx++;
				}
				if(!isNumberConst(rd)) idx--;

				double constVal = Double.parseDouble(sb.toString());
				insert(l, CONST, constVal);
				continue compiling;
			}else if(rd == '$'){ //parse variable
				insert(l, LD_VAR, s.charAt(++idx));
			}else if(getOperator(rd) != null){ //parse operator
				l.add(NO_OP);
				l.add(getOperator(rd));
			}else if(rd == '('){
				StringBuilder sb = new StringBuilder();
				while((rd = s.charAt(++idx)) != ')'){
					sb.append(rd);
				}
				int next_pID = ++last_pID;
				List<Object> sub = compilerSubroutine(sb.toString(), next_pID);
				insert(l,LD_BRA, next_pID);
				l.addAll(0, sub);
			}else if(isLowercaseLetter(rd)){
				StringBuilder sb = new StringBuilder();
				while(idx < s.length() && isLowercaseLetter(rd = s.charAt(idx))){
					sb.append(rd);
					idx++;
				}
				int ins = insert(l, CALLF, sb.toString());
				
				sb=new StringBuilder();
				if(rd == '('){
					while((rd = s.charAt(++idx)) != ')'){
						sb.append(rd);
					}
					String[] params = sb.toString().split(",");
					for(String par:params){
						int next_pID = ++last_pID;
						List<Object> sub = compilerSubroutine(par, next_pID);
						l.addAll(0, sub);
						ins += sub.size();
						l.add(ins, LD_BRA);
						ins++;
						l.add(ins, next_pID);
						ins++;
					}
				}else if(rd == ' '){
					idx++;
					while(idx < s.length() && (rd = s.charAt(idx)) != ' '){
						sb.append(rd);
						idx++;
					}
					idx--;
					List<Object> sub = compilerSubroutine(sb.toString(), 0);
					l.addAll(ins, sub);
				}else idx--;
			}
		}
		if(pID != 0){
			l.add(ST_BRA);
			l.add(pID);
		}
		return l;
	}
	
	/** Inserts data at the last empty slot (NO_OP or end of list)
	  * @return position of the opcode inserted */
	private static int insert(List<Object> l, Byte opcode, Object operand){
		int ins = l.lastIndexOf(NO_OP);
		if(ins == -1){
			ins = l.size();
			l.add(opcode);
			l.add(operand);
		}else{
			l.set(ins, opcode);
			l.add(ins+1, operand);
		}
		return ins;
	}
	
	public static Byte getOperator(char rd){
		switch (rd) {
		case '+':
			return OP_ADD;
		case '-':
			return OP_SBT;
		case '*':
			return OP_MUL;
		case '/':
			return OP_DIV;
		case '%':
			return OP_MOD;
		case '\\':
			return OP_DINT;
		default:
			return null;
		}
	}

	public static boolean isNumberConst(char c) {
		return (c<='9' && c>='0') || c == '.' || c == 'E';
	}
	
	public static boolean isLowercaseLetter(char c) {
		return (c<='z' && c>='a') || c == '_';
	}
}
