package csokicraft.util.eqdf.novacompiler.ast;

import csokicraft.util.eqdf.novacompiler.ast.impl.ValueNode;

public abstract class UnaryNode implements SyntaxNode{
	protected SyntaxNode child;
	
	public UnaryNode(SyntaxNode node){
		child=node;
	}

	/** Used by {@link #toString()}. Returns the prefix representation of this operator */
	public abstract String getPrefix();

	@Override
	public String toString(){
		if(child instanceof ValueNode) {
			return getPrefix()+child.toString();
		}
		return getPrefix()+"("+child.toString()+")";
	}
}
