package csokicraft.util.geom;

public class Point2<T extends Number> implements IPoint<T> {
	protected T x,y;
	
	public Point2(T a, T b){
		x=a;
		y=b;
	}

	@Override
	public int getDimensions() {
		return 2;
	}

	@Override
	public T getX(){
		return x;
	}

	public T getY(){
		return y;
	}

	@Override
	public IVector<T> getBaseVec() {
		return new Vector2<T>(x,y);
	}
}
