package csokicraft.util.geom;

public class Vector2<T extends Number> implements IVector<T> {
	protected T i, j;

	public Vector2(T a, T b) {
		i=a;
		j=b;
	}

	@Override
	public int getDimensions() {
		return 2;
	}

	public T getX(){
		return i;
	}

	public T getY(){
		return j;
	}

	@Override
	public IPoint<T> translate(IPoint<T> p) {
		if(p instanceof Point2){
			Point2<T> pt=(Point2<T>) p;
			return new Point2<T>(GenericNumberArithmeticHelper.add(getX(), pt.getX()), GenericNumberArithmeticHelper.add(getY(), pt.getY()));
		}
		else return null;
	}

	@Override
	public IPoint<T> getEndPoint() {
		return new Point2<T>(i, j);
	}

	@Override
	public double getLength(){
		return Math.sqrt(GenericNumberArithmeticHelper.add(GenericNumberArithmeticHelper.square(i), GenericNumberArithmeticHelper.square(j)).doubleValue());
	}
}
