package csokicraft.util.mcforge;

import javax.vecmath.Vector3d;

import cpw.mods.fml.common.Mod;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

/** Things I commonly need for MCForge. Do not load in a non-MCForge domain!
  * @author CsokiCraft*/
@Mod(modid="CsokiCraftUtil", version="1.3.5", acceptedMinecraftVersions="1.6.4, 1.7.10")
public class UtilMcForge {
	/** @param here The location of the reference point
	  * @param face The side of the block we need to shift the location towards
	  * @return The location of the block which is next to the block at "here", touching it at its "face" side.*/
	public static Vector3d getPosAtSide(Vector3d here, ForgeDirection face){
		double x=here.x, y=here.y, z=here.z;
		switch(face){
		case UP:
			y++;
			break;
		case DOWN:
			y--;
			break;
		case EAST:
			x++;
			break;
		case WEST:
			x--;
			break;
		case NORTH:
			z--;
			break;
		case SOUTH:
			z++;
			break;
		default:
			break;
		}
		return new Vector3d(x, y, z);
	}
	/** Gets the direction of an entity based on their rotation
	  * @param yaw The yaw of the entity (e.rotationYaw)*/
	public static ForgeDirection getEntityOrientation(float yaw){
		int n=(int)Math.floor((double)(yaw * 4.0F / 360.0F) + 0.5D) & 3;
		switch (n) {
		case 0:
			return ForgeDirection.SOUTH;
		case 1:
			return ForgeDirection.WEST;
		case 2:
			return ForgeDirection.NORTH;
		case 3:
			return ForgeDirection.EAST;
		default:
			return ForgeDirection.UNKNOWN;
		}
	}
	
	/** Similar to {@link #getEntityOrientation(float)}, but takes pitch into consideration
	  * @param yaw The yaw of the entity (e.rotationYaw)
	  * @param pitch The pitch of the entity (e.rotationPitch)*/
	public static ForgeDirection getEntityOrientation(float yaw, float pitch){
		if(Math.abs(pitch)<=45) return getEntityOrientation(yaw);
		return Math.signum(pitch)==1?ForgeDirection.DOWN:ForgeDirection.UP;
	}
	
	/** Gives the ItemStack to the player. <br>
	  * Only call server-side! */
	public static void giveItemStack(EntityPlayer p, ItemStack is){
		EntityItem ent=new EntityItem(p.getEntityWorld(), p.posX, p.posY, p.posZ, is);
		ent.delayBeforeCanPickup=0;
		ent.func_145797_a(p.getCommandSenderName());
		p.getEntityWorld().spawnEntityInWorld(ent);
	}
}
