package csokicraft.util.mcforge;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

/** Things I commonly need for MCForge. Do not load in a non-MCForge domain!
  * Disclaimer: This version of UtilMcForge ONLY works on 1.10.
  * If you need it to work on older versions, use {@link UtilMcForge}
  * @author CsokiCraft*/
@Mod(modid="csokicraftutil", version="1.3.1", acceptedMinecraftVersions="1.10.2")
public class UtilMcForge10 {
	/** Gets the direction of an entity based on their rotation
	  * @param yaw The yaw of the entity (e.rotationYaw)*/
	public static EnumFacing getEntityOrientation(float yaw){
		int n=(int)Math.floor((double)(yaw * 4.0F / 360.0F) + 0.5D) & 3;
		switch (n) {
		case 0:
			return EnumFacing.SOUTH;
		case 1:
			return EnumFacing.WEST;
		case 2:
			return EnumFacing.NORTH;
		case 3:
			return EnumFacing.EAST;
		default:
			return null;
		}
	}
	
	/** Similar to {@link #getEntityOrientation(float)}, but takes pitch into consideration
	  * @param yaw The yaw of the entity (e.rotationYaw)
	  * @param pitch The pitch of the entity (e.rotationPitch)*/
	public static EnumFacing getEntityOrientation(float yaw, float pitch){
		if(Math.abs(pitch)<=45) return getEntityOrientation(yaw);
		return Math.signum(pitch)==1?EnumFacing.DOWN:EnumFacing.UP;
	}
	
	public static void moveAll(IItemHandler src, IItemHandler dest){
		int lenSrc=src.getSlots(), lenDest=dest.getSlots();
		outer:for(int i=0;i<lenSrc;i++){
			ItemStack slot=src.getStackInSlot(i);
			if(slot==null) continue outer;
			inner:for(int j=0;j<lenDest;j++){
				ItemStack remain=dest.insertItem(j, slot, true);
				int consumed=slot.stackSize;
				if(remain!=null)
					consumed-=remain.stackSize;
				if(consumed>0){
					ItemStack ex=src.extractItem(i, consumed, false);
					dest.insertItem(j, ex, false);
					slot.stackSize-=consumed;
					if(slot.stackSize<=0)
						break inner;
				}
			}
		}
	}

	/** Gives the ItemStack to the player. <br>
	  * Only call server-side! */
	public static void giveItemStack(EntityPlayer p, ItemStack is){
		EntityItem ent=new EntityItem(p.getEntityWorld(), p.posX, p.posY, p.posZ, is);
		ent.setNoPickupDelay();
		ent.setOwner(p.getCommandSenderEntity().getName());
		p.getEntityWorld().spawnEntityInWorld(ent);
	}
}
