package csokicraft.util.streaming;

import java.io.*;
import java.net.*;

import csokicraft.util.QueuedStream;

/** A fake socket with which you can simulate arbitrary data flow
  * @author CsokiCraft */
public class QueuedSocket extends Socket{
	protected InputStream in;
	protected OutputStream out;
	
	/** Sets up a {@link QueuedSocket} from the two pipes */
	public QueuedSocket(QueuedStream quIn, QueuedStream quOut) throws SocketException{
		super(new QueuedSocketImpl(quIn, quOut));
		in=quOut.getInputStream();
		out=quIn.getOutputStream();
	}
	
	/** Write a byte to the socket's buffer, which will appear in its {@link InputStream} */
	public void write(int b) throws IOException{
		out.write(b);
	}
	
	/** Read a byte that was sent from this socket's {@link OutputStream} */
	public int read() throws IOException{
		return in.read();
	}
	
	protected static class QueuedSocketImpl extends SocketImpl{
		protected QueuedStream queueIn;
		protected InputStream in;
		protected QueuedStream queueOut;
		protected OutputStream out;
		
		public QueuedSocketImpl(QueuedStream inst, QueuedStream quOut){
			queueIn=inst;
			queueOut=quOut;
		}

		@Override
		public Object getOption(int arg0) throws SocketException{
			return null;
		}

		@Override
		public void setOption(int arg0, Object arg1) throws SocketException{
			
		}

		@Override
		protected void accept(SocketImpl arg0) throws IOException{
			
		}

		@Override
		protected int available() throws IOException{
			return in.available();
		}

		@Override
		protected void bind(InetAddress arg0, int arg1) throws IOException{
			throw new IOException("Can't re-bind QueuedSocket!");
		}

		@Override
		protected void close() throws IOException{
			System.out.println("QueuedSocket can't close()!");
		}

		@Override
		protected void connect(String arg0, int arg1) throws IOException{
			System.out.println("QueuedSocket doesn't need connect()!");
		}

		@Override
		protected void connect(InetAddress arg0, int arg1) throws IOException{
			connect(arg0, arg1);
		}

		@Override
		protected void connect(SocketAddress arg0, int arg1) throws IOException{
			connect(arg0, arg1);
		}

		@Override
		protected void create(boolean arg0) throws IOException{
			in=queueIn.getInputStream();
			out=queueOut.getOutputStream();
		}

		@Override
		protected InputStream getInputStream() throws IOException{
			return in;
		}

		@Override
		protected OutputStream getOutputStream() throws IOException{
			return out;
		}

		@Override
		protected void listen(int arg0) throws IOException{
			
		}

		@Override
		protected void sendUrgentData(int arg0) throws IOException{
			out.write(arg0);
		}
	}
	
	
}
